/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.api.functions.ByteSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiTeleporterStatus
extends GuiTexturedElement {
    private static final ResourceLocation NEEDS_ENERGY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_needs_energy.png");
    private static final ResourceLocation NO_FRAME = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frame.png");
    private static final ResourceLocation NO_FREQUENCY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_frequency.png");
    private static final ResourceLocation NO_LINK = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_no_link.png");
    private static final ResourceLocation READY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "teleporter_ready.png");
    private final BooleanSupplier hasFrequency;
    private final ByteSupplier statusSupplier;

    public GuiTeleporterStatus(IGuiWrapper gui, BooleanSupplier hasFrequency, ByteSupplier statusSupplier) {
        super(NO_FREQUENCY, gui, 6, 6, 18, 18);
        this.hasFrequency = hasFrequency;
        this.statusSupplier = statusSupplier;
        this.setButtonBackground(GuiElement.ButtonBackground.DEFAULT);
    }

    protected int func_230989_a_(boolean hovering) {
        return 1;
    }

    @Override
    protected ResourceLocation getResource() {
        if (this.hasFrequency.getAsBoolean()) {
            switch (this.statusSupplier.getAsByte()) {
                case 1: {
                    return READY;
                }
                case 2: {
                    return NO_FRAME;
                }
                case 4: {
                    return NEEDS_ENERGY;
                }
            }
            return NO_LINK;
        }
        return NO_FREQUENCY;
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiTeleporterStatus.minecraft.field_71446_o.func_110577_a(this.getResource());
        GuiTeleporterStatus.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.displayTooltip(matrix, this.getStatusDisplay(), mouseX, mouseY);
    }

    private ITextComponent getStatusDisplay() {
        if (this.hasFrequency.getAsBoolean()) {
            switch (this.statusSupplier.getAsByte()) {
                case 1: {
                    return MekanismLang.TELEPORTER_READY.translateColored(EnumColor.DARK_GREEN, new Object[0]);
                }
                case 2: {
                    return MekanismLang.TELEPORTER_NO_FRAME.translateColored(EnumColor.DARK_RED, new Object[0]);
                }
                case 4: {
                    return MekanismLang.TELEPORTER_NEEDS_ENERGY.translateColored(EnumColor.DARK_RED, new Object[0]);
                }
            }
            return MekanismLang.TELEPORTER_NO_LINK.translateColored(EnumColor.DARK_RED, new Object[0]);
        }
        return MekanismLang.NO_FREQUENCY.translateColored(EnumColor.DARK_RED, new Object[0]);
    }
}

