/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiUpgradeScrollList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiUpgradeManagement
extends GuiMekanismTile<TileEntityMekanism, MekanismTileContainer<TileEntityMekanism>> {
    private MekanismButton removeButton;
    private GuiUpgradeScrollList scrollList;
    private int supportedIndex;
    private int delay;

    public GuiUpgradeManagement(MekanismTileContainer<TileEntityMekanism> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.scrollList = new GuiUpgradeScrollList((IGuiWrapper)this, 24, 6, 66, 50, this.tile.getComponent());
        this.func_230480_a_(this.scrollList);
        this.func_230480_a_(new GuiElementHolder(this, 24, 56, 125, 14));
        this.func_230480_a_(new GuiInnerScreen(this, 90, 6, 59, 50));
        this.func_230480_a_(new GuiProgress(() -> this.tile.getComponent().getScaledUpgradeProgress(), ProgressType.INSTALLING, (IGuiWrapper)this, 154, 26));
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 6, this.field_147009_r + 6, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.removeButton = new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 136, this.field_147009_r + 57, 12, this.getButtonLocation("remove_upgrade"), () -> {
            if (this.scrollList.hasSelection()) {
                Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.REMOVE_UPGRADE, (TileEntity)this.tile, this.scrollList.getSelection().ordinal()));
            }
        });
        this.func_230480_a_(this.removeButton);
        this.updateEnabledButtons();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.delay < 40) {
            ++this.delay;
        } else {
            this.delay = 0;
            ++this.supportedIndex;
            this.supportedIndex %= this.tile.getComponent().getSupportedTypes().size();
        }
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.removeButton.field_230693_o_ = this.scrollList.hasSelection();
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        Upgrade[] supported;
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.UPGRADES_SUPPORTED.translate(new Object[0]), 26, 59, this.titleTextColor());
        if (this.scrollList.hasSelection()) {
            Upgrade selectedType = this.scrollList.getSelection();
            int amount = this.tile.getComponent().getUpgrades(selectedType);
            this.renderText(matrix, (ITextComponent)MekanismLang.UPGRADE_TYPE.translate(selectedType), 92, 8, 0.6f);
            this.renderText(matrix, (ITextComponent)MekanismLang.UPGRADE_COUNT.translate(amount, selectedType.getMax()), 92, 16, 0.6f);
            int text = 0;
            for (ITextComponent component : UpgradeUtils.getInfo(this.tile, selectedType)) {
                this.renderText(matrix, component, 92, 22 + 6 * text++, 0.6f);
            }
        } else {
            this.renderText(matrix, (ITextComponent)MekanismLang.UPGRADE_NO_SELECTION.translate(new Object[0]), 92, 8, 0.8f);
        }
        Set<Upgrade> supportedTypes = this.tile.getComponent().getSupportedTypes();
        if (!supportedTypes.isEmpty() && (supported = supportedTypes.toArray(new Upgrade[0])).length > this.supportedIndex) {
            this.renderUpgrade(matrix, supported[this.supportedIndex], 80, 57, 0.8f);
            this.drawString(matrix, (ITextComponent)TextComponentUtil.build(supported[this.supportedIndex]), 96, 59, this.titleTextColor());
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void renderText(MatrixStack matrix, ITextComponent component, int x, int y, float size) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(size, size, size);
        this.drawString(matrix, component, (int)(1.0f / size * (float)x), (int)(1.0f / size * (float)y), this.screenTextColor());
        matrix.func_227865_b_();
    }

    private void renderUpgrade(MatrixStack matrix, Upgrade type, int x, int y, float size) {
        this.renderItem(matrix, UpgradeUtils.getStack(type), (int)((float)x / size), (int)((float)y / size), size);
    }
}

