/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class VineDecoration
implements DungeonDecoration {
    private final float chance;

    public VineDecoration(float chance) {
        this.chance = chance;
    }

    @Override
    public void decorate(DungeonModel model, IWorld world, BlockPos pos, int width, int height, int length, MutableBoundingBox worldGenBounds, MutableBoundingBox structureBounds, DungeonPiece piece, int stage, boolean worldGen) {
        boolean ew = piece.field_186169_c == Rotation.NONE || piece.field_186169_c == Rotation.CLOCKWISE_180;
        int maxX = ew ? width : length;
        int maxZ = ew ? length : width;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < maxZ; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!worldGenBounds.func_175898_b((Vector3i)currentPos) || !structureBounds.func_175898_b((Vector3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.func_175623_d(currentPos)) continue;
                    BlockPos north = currentPos.func_177978_c();
                    BlockPos east = currentPos.func_177974_f();
                    BlockPos south = currentPos.func_177968_d();
                    BlockPos west = currentPos.func_177976_e();
                    BlockPos up = currentPos.func_177984_a();
                    boolean _north = worldGenBounds.func_175898_b((Vector3i)north) && structureBounds.func_175898_b((Vector3i)north) && VineBlock.func_196542_b((IBlockReader)world, (BlockPos)north, (Direction)Direction.NORTH);
                    boolean _east = worldGenBounds.func_175898_b((Vector3i)east) && structureBounds.func_175898_b((Vector3i)east) && VineBlock.func_196542_b((IBlockReader)world, (BlockPos)east, (Direction)Direction.EAST);
                    boolean _south = worldGenBounds.func_175898_b((Vector3i)south) && structureBounds.func_175898_b((Vector3i)south) && VineBlock.func_196542_b((IBlockReader)world, (BlockPos)south, (Direction)Direction.SOUTH);
                    boolean _west = worldGenBounds.func_175898_b((Vector3i)west) && structureBounds.func_175898_b((Vector3i)west) && VineBlock.func_196542_b((IBlockReader)world, (BlockPos)west, (Direction)Direction.WEST);
                    boolean bl = _up = worldGenBounds.func_175898_b((Vector3i)up) && structureBounds.func_175898_b((Vector3i)up) && VineBlock.func_196542_b((IBlockReader)world, (BlockPos)up, (Direction)Direction.UP);
                    if (!_north && !_east && !_south && !_west && !_up || !(DungeonBlocks.RANDOM.nextFloat() < this.chance)) continue;
                    world.func_180501_a(currentPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(_north))).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(_east))).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(_south))).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(_west))).func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(_up)), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "vines");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        return object;
    }
}

