/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import java.util.function.Supplier;
import net.minecraft.item.IItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;

public class SimpleItemTier
implements IItemTier {
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int harvestLevel;
    private final int enchantability;
    private final LazyValue<Ingredient> repairMaterial;

    public SimpleItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<Ingredient> repairMaterial) {
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.harvestLevel = harvestLevel;
        this.enchantability = enchantability;
        this.repairMaterial = new LazyValue(repairMaterial);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IItemTier other) {
        return SimpleItemTier.builder().from(other);
    }

    public int func_200926_a() {
        return this.maxUses;
    }

    public float func_200928_b() {
        return this.efficiency;
    }

    public float func_200929_c() {
        return this.attackDamage;
    }

    public int func_200925_d() {
        return this.harvestLevel;
    }

    public int func_200927_e() {
        return this.enchantability;
    }

    public Ingredient func_200924_f() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    public static class Builder {
        private int maxUses;
        private float efficiency;
        private float attackDamage;
        private int harvestLevel;
        private int enchantability;
        private Supplier<Ingredient> repairMaterial;

        private Builder() {
        }

        public Builder from(IItemTier other) {
            this.maxUses(other.func_200926_a());
            this.efficiency(other.func_200928_b());
            this.attackDamage(other.func_200929_c());
            this.harvestLevel(other.func_200925_d());
            this.enchantability(other.func_200927_e());
            this.repairMaterial(() -> ((IItemTier)other).func_200924_f());
            return this;
        }

        public Builder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder efficiency(float efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Builder enchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder repairMaterial(Supplier<Ingredient> repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public SimpleItemTier build() {
            return new SimpleItemTier(this.maxUses, this.efficiency, this.attackDamage, this.harvestLevel, this.enchantability, this.repairMaterial);
        }
    }
}

