/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.module.data.ToolData;

public interface IToolProvider {
    public static final Logger logger = LogManager.getLogger();

    public boolean canProvideTools(ItemStack var1);

    public ToolData getToolData(ItemStack var1);

    default public int getToolLevel(ItemStack itemStack, ToolType tool) {
        if (!this.canProvideTools(itemStack)) {
            return -1;
        }
        return this.getToolData(itemStack).getLevel(tool);
    }

    default public float getToolEfficiency(ItemStack itemStack, ToolType tool) {
        if (!this.canProvideTools(itemStack)) {
            return 0.0f;
        }
        if (this.getToolLevel(itemStack, tool) <= 0) {
            return 0.0f;
        }
        return this.getToolData(itemStack).getEfficiency(tool);
    }

    default public Set<ToolType> getTools(ItemStack itemStack) {
        if (!this.canProvideTools(itemStack)) {
            return Collections.emptySet();
        }
        return this.getToolData(itemStack).getValues();
    }

    default public Map<ToolType, Integer> getToolLevels(ItemStack itemStack) {
        if (!this.canProvideTools(itemStack)) {
            return Collections.emptyMap();
        }
        return this.getToolData(itemStack).getLevelMap();
    }

    default public ItemStack onCraftConsume(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, ToolType tool, int toolLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }

    default public ItemStack onActionConsume(ItemStack providerStack, ItemStack targetStack, PlayerEntity player, ToolType tool, int toolLevel, boolean consumeResources) {
        ItemStack result = targetStack.func_77946_l();
        return result;
    }
}

