/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.util.CastOptional;

public class OutcomePreview {
    public String moduleKey;
    public String variantName;
    public String variantKey;
    public String category;
    public int level;
    public GlyphData glyph;
    public ItemStack itemStack;
    public SchematicType type;
    public ToolData tools;
    public ItemStack[] materials;

    public OutcomePreview(String moduleKey, String variantKey, String variantName, String category, int level, GlyphData glyph, ItemStack itemStack, SchematicType type, ToolData tools, ItemStack[] materials) {
        this.moduleKey = moduleKey;
        this.variantKey = variantKey;
        this.variantName = variantName;
        this.category = category;
        this.level = level;
        this.glyph = glyph;
        this.itemStack = itemStack;
        this.type = type;
        this.tools = tools;
        this.materials = materials;
    }

    public boolean isApplied(ItemStack itemStack, String slot) {
        if (this.moduleKey != null) {
            return false;
        }
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).flatMap(module -> CastOptional.cast(module, ItemModuleMajor.class)).map(module -> module.getImprovementLevel(itemStack, this.variantKey) == this.level).orElse(false);
    }

    public OutcomePreview clone() {
        return new OutcomePreview(this.moduleKey, this.variantKey, this.variantName, this.category, this.level, this.glyph, this.itemStack.func_77946_l(), this.type, this.tools, this.materials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomePreview preview = (OutcomePreview)o;
        return Objects.equals(this.moduleKey, preview.moduleKey) && Objects.equals(this.variantKey, preview.variantKey) && this.level == preview.level;
    }

    public int hashCode() {
        return Objects.hash(this.moduleKey, this.variantKey);
    }
}

