/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.BaseSchematic;
import se.mickelus.tetra.module.schematic.SchematicType;

public abstract class BasicSchematic
extends BaseSchematic {
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot1";
    protected String key;
    protected ItemModule module;
    protected Item item;

    public BasicSchematic(String key, ItemModule module, Item item) {
        this.key = key;
        this.module = module;
        this.item = item;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)(this.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)(this.key + slotSuffix), (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.equals(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.module.getSlot().equals(slot);
    }

    protected ItemModule removePreviousModule(ItemStack itemStack) {
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        ItemModule previousModule = item.getModuleFromSlot(itemStack, this.module.getSlot());
        if (previousModule != null) {
            previousModule.removeModule(itemStack);
        }
        return previousModule;
    }

    @Override
    public SchematicType getType() {
        if (this.module instanceof ItemModuleMajor) {
            return SchematicType.major;
        }
        return SchematicType.minor;
    }

    @Override
    public GlyphData getGlyph() {
        return this.module.getDefaultData().glyph;
    }
}

