/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

public class OverlayGuiPotionSlot
extends GuiElement {
    private ItemStack itemStack;
    private int slot;
    private Minecraft mc;
    private KeyframeAnimation showAnimation;
    private FontRenderer fontRenderer;
    GuiTexture backdrop;

    public OverlayGuiPotionSlot(int x, int y, ItemStack itemStack, int slot, boolean animateUp) {
        super(x, y, 23, 23);
        this.setAttachmentPoint(GuiAttachment.middleLeft);
        this.setAttachmentAnchor(GuiAttachment.middleLeft);
        this.itemStack = itemStack;
        this.slot = slot;
        this.mc = Minecraft.func_71410_x();
        if (itemStack != null) {
            this.fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.field_71466_p;
        }
        this.backdrop = new GuiTexture(0, 0, 23, 23, 32, 28, GuiTextures.toolbelt);
        this.addChild((GuiElement)this.backdrop);
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY(animateUp ? (float)(y + 2) : (float)(y - 2), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay((int)(Math.random() * 300.0));
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        return true;
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.opacity == 1.0f) {
            this.drawItemStack(this.itemStack, this.x + refX + 3, this.y + refY + 2);
        }
    }

    private void drawItemStack(ItemStack itemStack, int x, int y) {
        RenderSystem.pushMatrix();
        GlStateManager.func_227734_k_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_227780_a_();
        this.mc.func_175599_af().func_180450_b(itemStack, x, y);
        this.mc.func_175599_af().func_180453_a(this.fontRenderer, itemStack, x, y, "");
        GlStateManager.func_227731_j_();
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
    }

    public int getSlot() {
        return this.slot;
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
    }

    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus = true;
        if ((mouseX -= refX + this.x) + (mouseY -= refY + this.y) < 12) {
            gainFocus = false;
        }
        if (mouseX + mouseY > 34) {
            gainFocus = false;
        }
        if (mouseX - mouseY > 8) {
            gainFocus = false;
        }
        if (mouseY - mouseX > 12) {
            gainFocus = false;
        }
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

