/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.mojang.blaze3d.matrix.MatrixStack;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;

public class HoloDiagonalGui
extends GuiElement {
    protected AnimationChain openAnimation;
    protected AnimationChain reopenAnimation;
    private static final float targetOpacity = 0.2f;
    protected boolean upRight = false;

    public HoloDiagonalGui(int x, int y, int size, GuiAttachment attachment, int delay) {
        super(x, y, size, size);
        this.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.setAttachmentPoint(attachment);
        if (attachment == GuiAttachment.bottomLeft || attachment == GuiAttachment.topRight) {
            this.upRight = true;
        }
        this.setOpacity(0.0f);
        this.openAnimation = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(300, (GuiElement)this).withDelay(delay).applyTo(new Applier[]{new Applier.Opacity(0.3f)}), new KeyframeAnimation(150, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.2f)})});
        this.reopenAnimation = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(300, (GuiElement)this).withDelay(delay / 10).applyTo(new Applier[]{new Applier.Opacity(0.8f)}), new KeyframeAnimation(150, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.2f)})});
    }

    public void animateOpen() {
        this.openAnimation.stop();
        this.reopenAnimation.stop();
        this.setOpacity(0.0f);
        this.openAnimation.start();
    }

    public void animateReopen() {
        this.openAnimation.stop();
        this.reopenAnimation.stop();
        this.setOpacity(0.0f);
        this.reopenAnimation.start();
    }

    public void stopAnimations() {
        this.openAnimation.stop();
        this.reopenAnimation.stop();
        this.setOpacity(0.0f);
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.upRight) {
            for (int i = 0; i < this.width; ++i) {
                HoloDiagonalGui.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + this.width - i - 1), (int)(refY + this.y + i), (int)(refX + this.x + this.width - i), (int)(refY + this.y + i + 1), (int)0xFFFFFF, (float)(this.getOpacity() * opacity));
            }
        } else {
            for (int i = 0; i < this.width; ++i) {
                HoloDiagonalGui.drawRect((MatrixStack)matrixStack, (int)(refX + this.x + i), (int)(refY + this.y + i), (int)(refX + this.x + i + 1), (int)(refY + this.y + i + 1), (int)0xFFFFFF, (float)(this.getOpacity() * opacity));
            }
        }
    }
}

