/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;

public class ExecuteEffect
extends ChargedAbilityEffect {
    public static final ExecuteEffect instance = new ExecuteEffect();

    ExecuteEffect() {
        super(20, 0.5, 40, 8.0, ItemEffect.execute, ChargedAbilityEffect.TargetRequirement.entity, UseAction.SPEAR, "raised");
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        if (!target.field_70170_p.field_72995_K) {
            AbilityUseResult result = this.isDefensive(item, itemStack, hand) ? this.defensiveExecute(attacker, item, itemStack, target) : this.regularExecute(attacker, item, itemStack, target, chargedTicks);
            this.playEffects(result != AbilityUseResult.fail, target, hitVec);
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        }
        attacker.func_71020_j(1.0f);
        attacker.func_226292_a_(hand, false);
        attacker.func_184811_cZ().func_185145_a((Item)item, this.getCooldown(item, itemStack));
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private AbilityUseResult regularExecute(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int chargedTicks) {
        AbilityUseResult result;
        int echoLevel;
        int overextendLevel;
        double revengeMultiplier;
        long harmfulCount = target.func_70651_bq().stream().filter(effect -> effect.func_188419_a().func_220303_e() == EffectType.HARMFUL).mapToInt(EffectInstance::func_76458_c).map(amp -> amp + 1).sum();
        if (target.func_70027_ad()) {
            ++harmfulCount;
        }
        float missingHealth = MathHelper.func_76131_a((float)(1.0f - target.func_110143_aJ() / target.func_110138_aP()), (float)0.0f, (float)1.0f);
        double efficiency = item.getEffectEfficiency(itemStack, ItemEffect.execute);
        double damageMultiplier = (double)missingHealth + (double)harmfulCount * efficiency / 100.0;
        double comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
        if (comboLevel > 0.0) {
            damageMultiplier *= 1.0 + comboLevel * (double)ComboPoints.get((Entity)attacker) / 100.0;
        }
        damageMultiplier += 1.0;
        if (this.canOvercharge(item, itemStack)) {
            damageMultiplier *= 1.0 + (double)(this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((revengeMultiplier = this.getRevengeMultiplier(attacker, item, itemStack)) > 0.0) {
            damageMultiplier *= revengeMultiplier;
        }
        if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0) {
            FoodStats foodStats = attacker.func_71024_bL();
            float exhaustion = Math.min(40.0f, (float)foodStats.func_75116_a() + foodStats.func_75115_e());
            damageMultiplier *= 1.0 + (double)((float)overextendLevel * exhaustion) * 0.25 / 100.0;
            attacker.func_71020_j(exhaustion);
        }
        if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
            this.echoExecute(attacker, item, itemStack, target);
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int exhilarationLevel;
            int momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum);
            if (momentumLevel > 0) {
                int duration = (int)((double)momentumLevel * damageMultiplier * 20.0);
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, duration, 0, false, false));
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && !target.func_70089_S()) {
                float maxHealth = target.func_110138_aP();
                int amplifier = Math.round((1.0f - missingHealth) / (float)exhilarationLevel * 100.0f) - 1;
                int duration = (int)(Math.min(200.0, item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration) * (double)maxHealth) * 20.0);
                if (amplifier >= 0 && duration > 0) {
                    attacker.func_195064_c(new EffectInstance((Effect)SmallStrengthPotionEffect.instance, duration, amplifier, false, true));
                }
            }
        }
        return result;
    }

    private void echoExecute(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        EchoHelper.echo(attacker, 100, () -> {
            float missingHealth;
            double damageMultiplier;
            long harmfulCount = target.func_70651_bq().stream().filter(effect -> effect.func_188419_a().func_220303_e() == EffectType.HARMFUL).mapToInt(EffectInstance::func_76458_c).map(amp -> amp + 1).sum();
            if (target.func_70027_ad()) {
                ++harmfulCount;
            }
            if ((damageMultiplier = (double)((missingHealth = MathHelper.func_76131_a((float)(1.0f - target.func_110143_aJ() / target.func_110138_aP()), (float)0.0f, (float)1.0f)) + (float)harmfulCount)) > 0.0) {
                AbilityUseResult result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f);
                this.playEffects(result != AbilityUseResult.fail, target, target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() / 2.0f), 0.0));
            }
        });
    }

    private AbilityUseResult defensiveExecute(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result;
        boolean targetFullHealth = target.func_110138_aP() == target.func_110143_aJ();
        double damageMultiplier = (float)item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) / 100.0f;
        if (targetFullHealth) {
            damageMultiplier += item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int amp = Optional.ofNullable(target.func_70660_b((Effect)SeveredPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
            amp += targetFullHealth ? 2 : 1;
            amp = Math.min(amp, 2);
            target.func_195064_c(new EffectInstance((Effect)SeveredPotionEffect.instance, 1200, amp, false, false));
        }
        return result;
    }

    private double getRevengeMultiplier(PlayerEntity player, ItemModularHandheld item, ItemStack itemStack) {
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (revengeLevel > 0 && (player.func_70651_bq().stream().anyMatch(effect -> effect.func_188419_a().func_220303_e() == EffectType.HARMFUL) || player.func_70027_ad())) {
            return 1.0 + (double)revengeLevel / 100.0;
        }
        return 0.0;
    }

    private void playEffects(boolean isSuccess, LivingEntity target, Vector3d hitVec) {
        if (isSuccess) {
            target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 0.8f);
            Random rand = target.func_70681_au();
            CastOptional.cast(target.field_70170_p, ServerWorld.class).ifPresent(world -> world.func_195598_a((IParticleData)new RedstoneParticleData(0.6f, 0.0f, 0.0f, 0.8f), hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * 0.3, rand.nextGaussian() * 0.3, (double)0.1f));
        } else {
            target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.8f);
        }
    }
}

