/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;

public class ComboPoints {
    private static Cache<Integer, Integer> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private static int getIdentifier(Entity entity) {
        return entity.field_70170_p.field_72995_K ? -entity.func_145782_y() : entity.func_145782_y();
    }

    public static void increment(Entity entity) {
        try {
            int identifier = ComboPoints.getIdentifier(entity);
            int points = Math.min(5, (Integer)cache.get((Object)identifier, () -> 0) + 1);
            cache.put((Object)identifier, (Object)points);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static int get(Entity entity) {
        try {
            return (Integer)cache.get((Object)ComboPoints.getIdentifier(entity), () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getAndReset(Entity entity) {
        try {
            int points = (Integer)cache.get((Object)ComboPoints.getIdentifier(entity), () -> 0);
            ComboPoints.reset(entity);
            return points;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void reset(Entity entity) {
        cache.invalidate((Object)ComboPoints.getIdentifier(entity));
    }

    public static boolean canSpend(LivingEntity entity) {
        return Stream.of(entity.func_184614_ca(), entity.func_184592_cb()).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).anyMatch(itemStack -> ComboPoints.canSpend((IModularItem)itemStack.func_77973_b(), itemStack));
    }

    public static boolean canSpend(IModularItem item, ItemStack itemStack) {
        return item.getEffectLevel(itemStack, ItemEffect.abilityCombo) > 0;
    }

    public static void onAttackEntity(AttackEntityEvent event) {
        if (event.getTarget().func_70075_an() && ComboPoints.canSpend((LivingEntity)event.getPlayer()) && (double)event.getPlayer().func_184825_o(0.0f) > 0.9) {
            ComboPoints.increment((Entity)event.getPlayer());
        }
    }
}

