/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class QuadRenderer {
    public final Vertex[] vertexPositions;
    public final Vector3f normal;

    public QuadRenderer(float x, float y, float z, float w, float h, float u, float v, float texWidth, float texHeight, boolean mirror, Direction direction) {
        float u1 = u / texWidth;
        float u2 = (u + w) / texWidth;
        float v1 = v / texHeight;
        float v2 = (v + h) / texHeight;
        if (mirror) {
            float temp = u1;
            u1 = u2;
            u2 = temp;
        }
        switch (direction) {
            default: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + w, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + w, y + 0.0f, z + h, u2, v2), new Vertex(x + 0.0f, y + 0.0f, z + h, u1, v2)};
                break;
            }
            case UP: {
                this.vertexPositions = new Vertex[]{new Vertex(x + w, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + 0.0f, z + h, u2, v2), new Vertex(x + w, y + 0.0f, z + h, u1, v2)};
                break;
            }
            case WEST: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + w, u2, v1), new Vertex(x + 0.0f, y + h, z + w, u2, v2), new Vertex(x + 0.0f, y + h, z + 0.0f, u1, v2)};
                break;
            }
            case NORTH: {
                this.vertexPositions = new Vertex[]{new Vertex(x + w, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + h, z + 0.0f, u2, v2), new Vertex(x + w, y + h, z + 0.0f, u1, v2)};
                break;
            }
            case EAST: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + w, u1, v1), new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + 0.0f, y + h, z + 0.0f, u2, v2), new Vertex(x + 0.0f, y + h, z + w, u1, v2)};
                break;
            }
            case SOUTH: {
                this.vertexPositions = new Vertex[]{new Vertex(x + 0.0f, y + 0.0f, z + 0.0f, u1, v1), new Vertex(x + w, y + 0.0f, z + 0.0f, u2, v1), new Vertex(x + w, y + h, z + 0.0f, u2, v2), new Vertex(x + 0.0f, y + h, z + 0.0f, u1, v2)};
            }
        }
        this.normal = direction.func_229386_k_();
        if (mirror) {
            this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
        }
    }

    public void render(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.func_227860_a_();
        MatrixStack.Entry last = matrixStack.func_227866_c_();
        Matrix4f matrix = last.func_227870_a_();
        Matrix3f normal = last.func_227872_b_();
        Vector3f vector3f = this.normal.func_229195_e_();
        vector3f.func_229188_a_(normal);
        float originX = vector3f.func_195899_a();
        float originY = vector3f.func_195900_b();
        float originZ = vector3f.func_195902_c();
        for (Vertex vertex : this.vertexPositions) {
            Vector4f pos = new Vector4f(vertex.pos.func_195899_a() / 16.0f, vertex.pos.func_195900_b() / 16.0f, vertex.pos.func_195902_c() / 16.0f, 1.0f);
            pos.func_229372_a_(matrix);
            buffer.func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), red, green, blue, alpha, vertex.u, vertex.v, packedOverlay, packedLight, originX, originY, originZ);
        }
        matrixStack.func_227865_b_();
    }

    static class Vertex {
        final Vector3f pos;
        final float u;
        final float v;

        public Vertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public Vertex(Vector3f pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }
}

