/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerContainer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerTile;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.VerticalTabGroupGui;

@OnlyIn(value=Dist.CLIENT)
public class ForgedContainerScreen
extends ContainerScreen<ForgedContainerContainer> {
    private static final ResourceLocation containerTexture = new ResourceLocation("tetra", "textures/gui/forged-container.png");
    private final ForgedContainerTile tileEntity;
    private final ForgedContainerContainer container;
    private final GuiElement guiRoot;
    private final AnimationChain slotTransition;
    private final VerticalTabGroupGui compartmentButtons;

    public ForgedContainerScreen(ForgedContainerContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 179;
        this.field_147000_g = 176;
        this.tileEntity = container.getTile();
        this.container = container;
        this.guiRoot = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.guiRoot.addChild((GuiElement)new GuiTexture(0, -13, 179, 128, containerTexture));
        this.guiRoot.addChild((GuiElement)new GuiTexture(0, 103, 179, 106, GuiTextures.playerInventory));
        this.compartmentButtons = new VerticalTabGroupGui(10, 26, this::changeCompartment, containerTexture, 0, 128, (String[])IntStream.range(0, ForgedContainerTile.compartmentCount).mapToObj(i -> I18n.func_135052_a((String)("tetra.forged_container.compartment_" + i), (Object[])new Object[0])).toArray(String[]::new));
        this.guiRoot.addChild((GuiElement)this.compartmentButtons);
        GuiRect slotTransitionElement = new GuiRect(12, 0, 152, 101, 0);
        slotTransitionElement.setOpacity(0.0f);
        this.guiRoot.addChild((GuiElement)slotTransitionElement);
        this.slotTransition = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(30, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.3f)}), new KeyframeAnimation(50, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
    }

    private void changeCompartment(int index) {
        this.container.changeCompartment(index);
        this.compartmentButtons.setActive(index);
        this.slotTransition.stop();
        this.slotTransition.start();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        super.func_231044_a_(mouseX, mouseY, button);
        return this.guiRoot.onMouseClick((int)mouseX, (int)mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        super.func_231048_c_(mouseX, mouseY, button);
        this.guiRoot.onMouseRelease((int)mouseX, (int)mouseY, button);
        return true;
    }

    public boolean func_231042_a_(char typecChar, int keyCode) {
        this.compartmentButtons.keyTyped(typecChar);
        return false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        int size = ForgedContainerTile.compartmentSize;
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            for (int i = 0; i < ForgedContainerTile.compartmentCount; ++i) {
                boolean hasContent = false;
                for (int j = 0; j < size; ++j) {
                    if (itemHandler.getStackInSlot(i * size + j).func_190926_b()) continue;
                    hasContent = true;
                    break;
                }
                this.compartmentButtons.setHasContent(i, hasContent);
            }
        });
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(matrixStack, 0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.func_230451_b_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.guiRoot.draw(matrixStack, x, y, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, 1.0f);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }
}

