/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.util.TileEntityOptional;

public class FracturedBedrockBlock
extends TetraBlock {
    public static final String unlocalizedName = "fractured_bedrock";
    @ObjectHolder(value="tetra:fractured_bedrock")
    public static FracturedBedrockBlock instance;

    public FracturedBedrockBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
        this.setRegistryName(unlocalizedName);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FracturedBedrockTile();
    }

    public static boolean canPierce(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        return Blocks.field_150357_h.equals(blockState.func_177230_c()) || SeepingBedrockBlock.instance.equals(blockState.func_177230_c()) && !SeepingBedrockBlock.isActive(blockState);
    }

    public static void pierce(World world, BlockPos pos, int amount) {
        FracturedBedrockTile tile = TileEntityOptional.from((IBlockReader)world, pos, FracturedBedrockTile.class).orElse(null);
        if (tile == null && FracturedBedrockBlock.canPierce(world, pos)) {
            BlockState blockState = world.func_180495_p(pos);
            world.func_180501_a(pos, instance.func_176223_P(), 2);
            tile = TileEntityOptional.from((IBlockReader)world, pos, FracturedBedrockTile.class).orElse(null);
            if (!world.field_72995_K) {
                tile.updateLuck(SeepingBedrockBlock.instance.equals(blockState.func_177230_c()));
            }
        }
        if (tile != null) {
            tile.activate(amount);
        }
    }
}

