/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class PropertyMatcher
implements Predicate<BlockState> {
    public static final PropertyMatcher any = new PropertyMatcher();
    private Block block = null;
    private final Map<Property<?>, Predicate<?>> propertyPredicates = Maps.newHashMap();

    @Override
    public boolean test(BlockState blockState) {
        if (this.block != null && this.block != blockState.func_177230_c()) {
            return false;
        }
        for (Map.Entry<Property<?>, Predicate<?>> entry : this.propertyPredicates.entrySet()) {
            if (this.matches(blockState, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean matches(BlockState blockState, Property<T> property, Predicate<T> predicate) {
        return predicate.test(blockState.func_177229_b(property));
    }

    public <V extends Comparable<V>> PropertyMatcher where(Property<V> property, Predicate<? extends V> is) {
        this.propertyPredicates.put(property, is);
        return this;
    }

    public static PropertyMatcher deserialize(JsonElement json) {
        PropertyMatcher result = new PropertyMatcher();
        if (json.isJsonObject()) {
            ResourceLocation resourceLocation;
            String blockString;
            JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)json, (String)"propertyMatcher");
            if (jsonObject.has("block") && (blockString = jsonObject.get("block").getAsString()) != null && ForgeRegistries.BLOCKS.containsKey(resourceLocation = new ResourceLocation(blockString))) {
                result.block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            }
            if (result.block != null && jsonObject.has("state")) {
                StateContainer stateContainer = result.block.func_176194_O();
                for (Map.Entry entry : jsonObject.get("state").getAsJsonObject().entrySet()) {
                    Property property = stateContainer.func_185920_a((String)entry.getKey());
                    if (property == null) {
                        throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + result.block.func_149739_a() + "'");
                    }
                    String s = JSONUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = property.func_185929_b(s);
                    if (!optional.isPresent()) {
                        throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + result.block.func_149739_a() + "'");
                    }
                    result.propertyPredicates.put((Property<?>)property, (Predicate<?>)Predicates.equalTo(optional.get()));
                }
            }
        } else {
            ResourceLocation resourceLocation;
            String blockString = json.getAsString();
            if (blockString != null && ForgeRegistries.BLOCKS.containsKey(resourceLocation = new ResourceLocation(blockString))) {
                result.block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            }
        }
        return result;
    }
}

