/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.capability.templates.ArcheryBowItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.references.EnsorcReferences;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ArcheryEvents {
    private ArcheryEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowLooseEvent(ArrowLooseEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        PlayerEntity shooter = event.getPlayer();
        event.setCanceled(((IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow))).fireArrow(ArcheryHelper.findAmmo(shooter, bow), shooter, event.getCharge(), event.getWorld()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowNockEvent(ArrowNockEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        PlayerEntity shooter = event.getPlayer();
        ItemStack ammo = ArcheryHelper.findAmmo(shooter, bow);
        if (ammo.func_190926_b() && Utils.getItemEnchantmentLevel(Enchantments.field_185312_x, bow) > 0) {
            ammo = new ItemStack((IItemProvider)Items.field_151032_g);
        }
        if (!ammo.func_190926_b()) {
            shooter.func_184598_c(event.getHand());
            event.setAction(ActionResult.func_226249_b_((Object)bow));
        } else if (!shooter.field_71075_bZ.field_75098_d) {
            event.setAction(ActionResult.func_226251_d_((Object)bow));
        }
    }

    @SubscribeEvent
    public static void handleItemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        int encQuickDraw = Utils.getItemEnchantmentLevel(EnsorcReferences.QUICK_DRAW, event.getItem());
        if (encQuickDraw > 0 && event.getDuration() > event.getItem().func_77988_m() - 20) {
            event.setDuration(event.getDuration() - encQuickDraw);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        int encVolley;
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = event.getSource().func_76346_g();
        if (entity instanceof ProjectileEntity) {
            return;
        }
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (source.field_76373_n.equals("arrow") && (encVolley = Utils.getHeldEnchantmentLevel((LivingEntity)attacker, EnsorcReferences.VOLLEY)) > 0) {
            entity.field_70172_ad = 0;
        }
    }
}

