/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.level.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LootGeneratorBlock
extends AirBlock {
    private final Supplier<Block> lootBlock;
    private final Supplier<IParticleData> particleOptions;

    public LootGeneratorBlock(AbstractBlock.Properties properties, Supplier<Block> lootBlock, Supplier<IParticleData> particleOptions) {
        super(properties);
        this.lootBlock = lootBlock;
        this.particleOptions = particleOptions;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    }

    public void func_180655_c(BlockState blockState, World level, BlockPos pos, Random random) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71442_b.func_178889_l() == GameType.CREATIVE) {
            level.func_195594_a(this.particleOptions.get(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void func_225542_b_(BlockState blockState, ServerWorld level, BlockPos pos, Random random) {
        super.func_225542_b_(blockState, level, pos, random);
        BlockState lootBlockState = this.lootBlock.get().func_176223_P();
        boolean lootExists = level.func_234853_a_(new AxisAlignedBB(pos.func_177978_c().func_177976_e(), pos.func_177968_d().func_177974_f())).anyMatch(lootBlockState::equals);
        if (!lootExists) {
            if (level.func_175623_d(pos.func_177978_c())) {
                level.func_175656_a(pos.func_177978_c(), lootBlockState);
            } else if (level.func_175623_d(pos.func_177974_f())) {
                level.func_175656_a(pos.func_177974_f(), lootBlockState);
            } else if (level.func_175623_d(pos.func_177968_d())) {
                level.func_175656_a(pos.func_177968_d(), lootBlockState);
            } else if (level.func_175623_d(pos.func_177976_e())) {
                level.func_175656_a(pos.func_177976_e(), lootBlockState);
            }
        }
    }
}

