/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.grenade;

import com.craftingdead.core.particle.RGBFlashParticleData;
import com.craftingdead.core.world.entity.grenade.GrenadeEntity;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.craftingdead.survival.world.item.SurvivalItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class PipeGrenadeEntity
extends GrenadeEntity {
    private static final RGBFlashParticleData RED_FLASH = new RGBFlashParticleData(1.0f, 0.35f, 0.35f, 1.0f);

    public PipeGrenadeEntity(EntityType<? extends GrenadeEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public PipeGrenadeEntity(LivingEntity thrower, World worldIn) {
        super((EntityType)SurvivalEntityTypes.PIPE_GRENADE.get(), thrower, worldIn);
    }

    public Integer getMinimumTicksUntilAutoActivation() {
        return 100;
    }

    public void activatedChanged(boolean activated) {
        if (activated && !this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
            this.field_70170_p.func_230546_a_((Entity)this, this.createDamageSource(), null, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_(), 4.0f, false, Explosion.Mode.NONE);
        }
    }

    public void onGrenadeTick() {
        if (this.field_70173_aa % 6 == 0) {
            if (this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_195590_a((IParticleData)RED_FLASH, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            } else {
                float pitchProgress = (float)this.field_70173_aa / (float)this.getMinimumTicksUntilAutoActivation().intValue();
                float gradualPitch = MathHelper.func_219799_g((float)pitchProgress, (float)1.0f, (float)2.0f);
                this.func_184185_a(SoundEvents.field_193807_ew, 1.7f, gradualPitch);
            }
        }
    }

    public boolean isAttracting() {
        return true;
    }

    public GrenadeItem asItem() {
        return (GrenadeItem)SurvivalItems.PIPE_GRENADE.get();
    }

    public void onMotionStop(int stopsCount) {
    }
}

