/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.survival.world.entity.SupplyDropEntity;
import com.craftingdead.survival.world.entity.grenade.PipeGrenadeEntity;
import com.craftingdead.survival.world.entity.monster.AdvancedZombieEntity;
import com.craftingdead.survival.world.entity.monster.DoctorZombieEntity;
import com.craftingdead.survival.world.entity.monster.FastZombieEntity;
import com.craftingdead.survival.world.entity.monster.GiantZombieEntity;
import com.craftingdead.survival.world.entity.monster.PoliceZombieEntity;
import com.craftingdead.survival.world.entity.monster.TankZombieEntity;
import com.craftingdead.survival.world.entity.monster.WeakZombieEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SurvivalEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"craftingdeadsurvival");
    private static final List<EntityType<?>> toRegister = new ArrayList();
    public static final RegistryObject<EntityType<PipeGrenadeEntity>> PIPE_GRENADE = ENTITY_TYPES.register("pipe_grenade", () -> SurvivalEntityTypes.create("pipe_grenade", EntityType.Builder.func_220322_a(PipeGrenadeEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(4).func_220321_a(0.25f, 0.5f).setShouldReceiveVelocityUpdates(false)));
    public static final RegistryObject<EntityType<SupplyDropEntity>> SUPPLY_DROP = ENTITY_TYPES.register("supply_drop", () -> SurvivalEntityTypes.create("supply_drop", EntityType.Builder.func_220322_a(SupplyDropEntity::new, (EntityClassification)EntityClassification.MISC)));
    public static EntityType<AdvancedZombieEntity> advancedZombie;
    public static EntityType<FastZombieEntity> fastZombie;
    public static EntityType<TankZombieEntity> tankZombie;
    public static EntityType<WeakZombieEntity> weakZombie;
    public static EntityType<AdvancedZombieEntity> policeZombie;
    public static EntityType<AdvancedZombieEntity> doctorZombie;
    public static EntityType<GiantZombieEntity> giantZombie;

    public static void initialize() {
        advancedZombie = SurvivalEntityTypes.add("advanced_zombie", EntityType.Builder.func_220322_a(AdvancedZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        fastZombie = SurvivalEntityTypes.add("fast_zombie", EntityType.Builder.func_220322_a(FastZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        tankZombie = SurvivalEntityTypes.add("tank_zombie", EntityType.Builder.func_220322_a(TankZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        weakZombie = SurvivalEntityTypes.add("weak_zombie", EntityType.Builder.func_220322_a(WeakZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        policeZombie = SurvivalEntityTypes.add("police_zombie", EntityType.Builder.func_220322_a(PoliceZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        doctorZombie = SurvivalEntityTypes.add("doctor_zombie", EntityType.Builder.func_220322_a(DoctorZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(0.6f, 1.95f).setShouldReceiveVelocityUpdates(false));
        giantZombie = SurvivalEntityTypes.add("giant_zombie", EntityType.Builder.func_220322_a(GiantZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(64).setUpdateInterval(3).func_220321_a(3.6f, 12.0f).setShouldReceiveVelocityUpdates(false));
        EntitySpawnPlacementRegistry.func_209343_a(advancedZombie, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AdvancedZombieEntity::checkAdvancedZombieSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a(fastZombie, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AdvancedZombieEntity::checkAdvancedZombieSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a(tankZombie, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AdvancedZombieEntity::checkAdvancedZombieSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a(weakZombie, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AdvancedZombieEntity::checkAdvancedZombieSpawnRules);
    }

    public static void registerAll(RegistryEvent.Register<EntityType<?>> event) {
        toRegister.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    private static <T extends Entity> EntityType<T> add(String registryName, EntityType.Builder<T> builder) {
        ResourceLocation resourceLocation = new ResourceLocation("craftingdeadsurvival", registryName);
        EntityType entityType = builder.func_206830_a(resourceLocation.toString());
        entityType.setRegistryName(resourceLocation);
        toRegister.add(entityType);
        return entityType;
    }

    private static <T extends Entity> EntityType<T> create(String registryName, EntityType.Builder<T> builder) {
        return builder.func_206830_a(new ResourceLocation("craftingdeadsurvival", registryName).toString());
    }
}

