/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.action;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.delegated.DelegatedActionType;
import com.craftingdead.core.world.action.delegated.DelegatedBlockActionType;
import com.craftingdead.core.world.action.delegated.DelegatedEntityActionType;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.item.SurvivalItems;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class SurvivalActionTypes {
    public static final DeferredRegister<ActionType> ACTION_TYPES = DeferredRegister.create(ActionType.class, (String)"craftingdeadsurvival");
    public static final RegistryObject<ActionType> SHRED_CLOTHING = ACTION_TYPES.register("shred_clothing", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.getCapability(Capabilities.CLOTHING).isPresent()).addDelegatedAction((DelegatedActionType)DelegatedEntityActionType.builder().setCustomAction(extension -> {
        Random random = extension.getEntity().func_70681_au();
        int randomRagAmount = random.nextInt(3) + 3;
        for (int i = 0; i < randomRagAmount; ++i) {
            if (random.nextBoolean()) {
                extension.getEntity().func_199701_a_(new ItemStack(() -> SurvivalItems.CLEAN_RAG.get()));
                continue;
            }
            extension.getEntity().func_199701_a_(new ItemStack(() -> SurvivalItems.DIRTY_RAG.get()));
        }
    }, Float.valueOf(1.0f)).build()).build());
    public static final RegistryObject<ActionType> USE_SPLINT = ACTION_TYPES.register("use_splint", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == SurvivalItems.SPLINT.get()).addDelegatedAction((DelegatedActionType)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS.andThen(extension -> extension == null || !extension.getEntity().func_70644_a((Effect)SurvivalMobEffects.BROKEN_LEG.get()) ? Optional.empty() : Optional.of(extension))).build()).build());
    public static final RegistryObject<ActionType> USE_CLEAN_RAG = ACTION_TYPES.register("use_clean_rag", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == SurvivalItems.CLEAN_RAG.get()).setTotalDurationTicks(16).addDelegatedAction((DelegatedActionType)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS.andThen(extension -> extension == null || !extension.getEntity().func_70644_a((Effect)SurvivalMobEffects.BLEEDING.get()) ? Optional.empty() : Optional.of(extension))).setReturnItem(SurvivalItems.BLOODY_RAG)).build()).build());
    public static final RegistryObject<ActionType> WASH_RAG = ACTION_TYPES.register("wash_rag", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == SurvivalItems.DIRTY_RAG.get() || itemStack.func_77973_b() == SurvivalItems.BLOODY_RAG.get()).addDelegatedAction((DelegatedActionType)((DelegatedBlockActionType.Builder)((DelegatedBlockActionType.Builder)DelegatedBlockActionType.builder().setReturnItem(SurvivalItems.CLEAN_RAG)).setFinishSound(SoundEvents.field_187630_M)).setPredicate(blockState -> blockState.func_204520_s().func_206886_c() == Fluids.field_204546_a).build()).build());
    public static final RegistryObject<ActionType> USE_SYRINGE_ON_ZOMBIE = ACTION_TYPES.register("use_syringe_on_zombie", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == ModItems.SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction((DelegatedActionType)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.OTHERS_ONLY.ofType(ZombieEntity.class)).setCustomAction(extension -> extension.getEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)extension.getEntity()), 2.0f), Float.valueOf(0.25f)).setReturnItem(() -> (Item)SurvivalItems.RBI_SYRINGE.get())).build()).build());
    public static final RegistryObject<ActionType> USE_CURE_SYRINGE = ACTION_TYPES.register("use_cure_syringe", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == SurvivalItems.CURE_SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction((DelegatedActionType)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).setReturnItem((Supplier)ModItems.SYRINGE)).build()).build());
    public static final RegistryObject<ActionType> USE_RBI_SYRINGE = ACTION_TYPES.register("use_rbi_syringe", () -> ItemActionType.builder().setHeldItemPredicate(itemStack -> itemStack.func_77973_b() == SurvivalItems.RBI_SYRINGE.get()).setTotalDurationTicks(16).addDelegatedAction((DelegatedActionType)((DelegatedEntityActionType.Builder)DelegatedEntityActionType.builder().setTargetSelector(TargetSelector.SELF_OR_OTHERS).addEffect(() -> new EffectInstance((Effect)SurvivalMobEffects.INFECTION.get(), 9999999), Float.valueOf(1.0f)).setReturnItem((Supplier)ModItems.SYRINGE)).build()).build());
}

