/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.client.renderer.entity;

import com.craftingdead.core.client.renderer.entity.layers.ClothingLayer;
import com.craftingdead.core.client.renderer.entity.layers.EquipmentLayer;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import com.craftingdead.survival.client.model.AdvancedZombieModel;
import com.craftingdead.survival.world.entity.monster.AdvancedZombieEntity;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;

public abstract class AbstractAdvancedZombieRenderer<T extends AdvancedZombieEntity, M extends AdvancedZombieModel<T>>
extends BipedRenderer<T, M> {
    public AbstractAdvancedZombieRenderer(EntityRendererManager renderManager, M model, float scale) {
        super(renderManager, model, scale);
        this.func_177094_a((LayerRenderer)new ClothingLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new EquipmentLayer.Builder().withRenderer((LivingRenderer)this).withSlot(ModEquipmentSlotType.MELEE).withCrouchingOrientation(true).build());
        this.func_177094_a((LayerRenderer)new EquipmentLayer.Builder().withRenderer((LivingRenderer)this).withSlot(ModEquipmentSlotType.VEST).withCrouchingOrientation(true).build());
        this.func_177094_a((LayerRenderer)new EquipmentLayer.Builder().withRenderer((LivingRenderer)this).withSlot(ModEquipmentSlotType.HAT).withHeadOrientation(true).withArbitraryTransformation(new TransformationMatrix(null, null, new Vector3f(-1.0f, -1.0f, 1.0f), null)).build());
        this.func_177094_a((LayerRenderer)new EquipmentLayer.Builder().withRenderer((LivingRenderer)this).withSlot(ModEquipmentSlotType.GUN).withCrouchingOrientation(true).build());
    }

    public ResourceLocation getTextureLocation(AdvancedZombieEntity entity) {
        ResourceLocation texture = new ResourceLocation("craftingdeadsurvival", "textures/entity/zombie/zombie" + entity.getTextureNumber() + ".png");
        return texture;
    }
}

