/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.survival.ModDist;
import com.craftingdead.survival.ServerConfig;
import com.craftingdead.survival.client.ClientDist;
import com.craftingdead.survival.data.SurvivalItemTagsProvider;
import com.craftingdead.survival.data.SurvivalRecipeProvider;
import com.craftingdead.survival.data.loot.SurvivalLootTableProvider;
import com.craftingdead.survival.particles.SurvivalParticleTypes;
import com.craftingdead.survival.server.ServerDist;
import com.craftingdead.survival.world.action.SurvivalActionTypes;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.craftingdead.survival.world.entity.SurvivalPlayerHandler;
import com.craftingdead.survival.world.entity.monster.AdvancedZombieEntity;
import com.craftingdead.survival.world.entity.monster.DoctorZombieEntity;
import com.craftingdead.survival.world.entity.monster.FastZombieEntity;
import com.craftingdead.survival.world.entity.monster.GiantZombieEntity;
import com.craftingdead.survival.world.entity.monster.PoliceZombieEntity;
import com.craftingdead.survival.world.entity.monster.TankZombieEntity;
import com.craftingdead.survival.world.entity.monster.WeakZombieEntity;
import com.craftingdead.survival.world.item.SurvivalItems;
import com.craftingdead.survival.world.item.enchantment.InfectionEnchantment;
import com.craftingdead.survival.world.item.enchantment.SurvivalEnchantments;
import com.craftingdead.survival.world.level.block.SurvivalBlocks;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="craftingdeadsurvival")
public class CraftingDeadSurvival {
    public static final String ID = "craftingdeadsurvival";
    private static final String H_CD_SERVER_CORE_ID = "hcdservercore";
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static CraftingDeadSurvival instance;
    private final ModDist modDist;

    public CraftingDeadSurvival() {
        instance = this;
        this.modDist = (ModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleEntityAttributeCreation);
        modEventBus.addListener(this::handleGatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverConfigSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SurvivalEntityTypes.initialize();
        modEventBus.addGenericListener(EntityType.class, SurvivalEntityTypes::registerAll);
        SurvivalEnchantments.ENCHANTMENTS.register(modEventBus);
        SurvivalActionTypes.ACTION_TYPES.register(modEventBus);
        SurvivalItems.ITEMS.register(modEventBus);
        SurvivalMobEffects.MOB_EFFECTS.register(modEventBus);
        SurvivalEntityTypes.ENTITY_TYPES.register(modEventBus);
        SurvivalParticleTypes.PARTICLE_TYPES.register(modEventBus);
        SurvivalBlocks.BLOCKS.register(modEventBus);
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public CraftingDeadSurvival getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao, Items.field_196100_at}), (ItemStack)new ItemStack((IItemProvider)SurvivalItems.CURE_SYRINGE.get()));
    }

    private void handleEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put(SurvivalEntityTypes.advancedZombie, AdvancedZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.doctorZombie, DoctorZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.fastZombie, FastZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.giantZombie, GiantZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.policeZombie, PoliceZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.tankZombie, TankZombieEntity.registerAttributes().func_233813_a_());
        event.put(SurvivalEntityTypes.weakZombie, WeakZombieEntity.registerAttributes().func_233813_a_());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new SurvivalItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            dataGenerator.func_200390_a((IDataProvider)new SurvivalRecipeProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new SurvivalLootTableProvider(dataGenerator));
        }
    }

    @SubscribeEvent
    public void handlePerformAction(LivingExtensionEvent.PerformAction<ItemAction> event) {
        Action action = event.getAction();
        LivingExtension target = action.getTarget().orElse(null);
        if (action.getType() == ActionTypes.USE_SYRINGE.get() && target != null && target.getEntity() instanceof ZombieEntity) {
            event.setCanceled(true);
            event.getLiving().performAction(((ActionType)SurvivalActionTypes.USE_SYRINGE_ON_ZOMBIE.get()).createAction(action.getPerformer(), target), true);
        }
    }

    @SubscribeEvent
    public void handleMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Block newBlock = (Block)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.func_110623_a()));
            if (newBlock != null) {
                mapping.remap((IForgeRegistryEntry)newBlock);
            }
        });
    }

    @SubscribeEvent
    public void handleMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Item newItem = (Item)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.func_110623_a()));
            if (newItem != null) {
                mapping.remap((IForgeRegistryEntry)newItem);
            }
        });
    }

    @SubscribeEvent
    public void handleAttachLivingExtensions(LivingExtensionEvent.Load event) {
        if (event.getLiving() instanceof PlayerExtension && !event.getLiving().getHandler(SurvivalPlayerHandler.ID).isPresent()) {
            PlayerExtension player = (PlayerExtension)event.getLiving();
            player.registerHandler(SurvivalPlayerHandler.ID, (LivingHandler)new SurvivalPlayerHandler(player));
        }
    }

    @SubscribeEvent
    public void handleRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().func_201670_d() && event.getItemStack().getCapability(Capabilities.CLOTHING).isPresent()) {
            PlayerExtension extension = PlayerExtension.getOrThrow((PlayerEntity)event.getPlayer());
            extension.performAction(((ActionType)SurvivalActionTypes.SHRED_CLOTHING.get()).createAction((LivingExtension)extension, null), true);
        }
    }

    @SubscribeEvent
    public void handleGunHitEntity(GunEvent.HitEntity event) {
        event.getTarget().getCapability(Capabilities.LIVING_EXTENSION).resolve().flatMap(living -> living.getHandler(SurvivalPlayerHandler.ID)).map(living -> (SurvivalPlayerHandler)living).ifPresent(playerHandler -> {
            float enchantmentPct = (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)SurvivalEnchantments.INFECTION.get()), (ItemStack)event.getItemStack()) / (float)((InfectionEnchantment)SurvivalEnchantments.INFECTION.get()).func_77325_b();
            playerHandler.infect(enchantmentPct);
        });
    }

    @SubscribeEvent
    public void handleBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)CraftingDeadSurvival.serverConfig.disableZombies.get()).booleanValue()) {
            return;
        }
        ListIterator<MobSpawnInfo.Spawners> iterator = event.getSpawns().getSpawner(EntityClassification.MONSTER).listIterator();
        while (iterator.hasNext()) {
            MobSpawnInfo.Spawners spawnEntry = (MobSpawnInfo.Spawners)iterator.next();
            if (spawnEntry.field_242588_c != EntityType.field_200725_aD) continue;
            iterator.add(new MobSpawnInfo.Spawners(SurvivalEntityTypes.advancedZombie, 40, 2, 8));
            iterator.add(new MobSpawnInfo.Spawners(SurvivalEntityTypes.fastZombie, 15, 2, 4));
            iterator.add(new MobSpawnInfo.Spawners(SurvivalEntityTypes.tankZombie, 5, 2, 4));
            iterator.add(new MobSpawnInfo.Spawners(SurvivalEntityTypes.weakZombie, 30, 2, 12));
        }
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
    }
}

