/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.render.ElementDrawers;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.network.grid.GridClearMessage;
import com.refinedmods.refinedstorage.network.grid.GridFluidInsertHeldMessage;
import com.refinedmods.refinedstorage.network.grid.GridFluidPullMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemGridScrollMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemInsertHeldMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemInventoryScrollMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemPullMessage;
import com.refinedmods.refinedstorage.network.grid.GridPatternCreateMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.grid.CraftingSettingsScreen;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.IdGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.InventoryTweaksGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.LastModifiedGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.NameGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.QuantityGridSorter;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.GridViewImpl;
import com.refinedmods.refinedstorage.screen.grid.view.IGridView;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.SearchWidget;
import com.refinedmods.refinedstorage.screen.widget.TabListWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSearchBoxModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSizeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSortingDirectionSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSortingTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridViewTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.grid.GridTile;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.tile.grid.portable.PortableGridTile;
import com.refinedmods.refinedstorage.util.RenderUtils;
import com.refinedmods.refinedstorage.util.TimeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GridScreen
extends BaseScreen<GridContainer>
implements IScreenInfoProvider {
    private static String searchQuery = "";
    private IGridView view;
    private SearchWidget searchField;
    private CheckboxWidget exactPattern;
    private CheckboxWidget processingPattern;
    private CheckboxWidget fluidCheckBox;
    private ScrollbarWidget scrollbar;
    private ScrollbarWidget patternScrollbar;
    private final IGrid grid;
    private final TabListWidget<GridContainer> tabs;
    private boolean wasConnected;
    private boolean doSort;
    private final int patternScrollOffsetAbsoluteMax = 24;
    private int slotNumber;
    private int patternScrollOffset;
    private int patternScrollOffsetMax;
    private boolean updatePatternOffset;

    public GridScreen(GridContainer container, final IGrid grid, PlayerInventory inventory, ITextComponent title) {
        super(container, 227, 0, inventory, title);
        this.grid = grid;
        this.view = new GridViewImpl(this, GridScreen.getDefaultSorter(), GridScreen.getSorters());
        this.wasConnected = this.grid.isGridActive();
        this.tabs = new TabListWidget<GridContainer>(this, new ElementDrawers<GridContainer>(this), grid::getTabs, grid::getTotalTabPages, grid::getTabPage, grid::getTabSelected, 5);
        this.tabs.addListener(new TabListWidget.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                grid.onTabSelectionChanged(tab);
            }

            @Override
            public void onPageChanged(int page) {
                grid.onTabPageChanged(page);
            }
        });
        if (grid instanceof GridNetworkNode && grid.getGridType() == GridType.PATTERN) {
            GridNetworkNode node = (GridNetworkNode)grid;
            node.getProcessingMatrix().addListener((handler, slot, reading) -> {
                this.updatePatternOffset = true;
            });
            node.getProcessingMatrixFluids().addListener((handler, slot, reading) -> {
                this.updatePatternOffset = true;
            });
        }
    }

    @Override
    protected void onPreInit() {
        super.onPreInit();
        this.doSort = true;
        this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void onPostInit(int x, int y) {
        ((GridContainer)this.field_147002_h).initSlots();
        this.tabs.init(this.field_146999_f - 32);
        this.scrollbar = new ScrollbarWidget(this, 174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof GridNetworkNode || this.grid instanceof PortableGridTile) {
            this.addSideButton(new RedstoneModeSideButton(this, this.grid instanceof GridNetworkNode ? NetworkNodeTile.REDSTONE_MODE : PortableGridTile.REDSTONE_MODE));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new SearchWidget(this.field_230712_o_, sx, sy, 82);
            this.searchField.func_212954_a(value -> {
                this.searchField.updateJei();
                this.getView().sort();
                searchQuery = value;
            });
            this.searchField.setMode(this.grid.getSearchBoxMode());
            this.searchField.func_146180_a(searchQuery);
        } else {
            this.searchField.field_230690_l_ = sx;
            this.searchField.field_230691_m_ = sy;
        }
        this.func_230480_a_((Widget)this.searchField);
        if (this.grid.getViewType() != -1) {
            this.addSideButton(new GridViewTypeSideButton(this, this.grid));
        }
        this.addSideButton(new GridSortingDirectionSideButton(this, this.grid));
        this.addSideButton(new GridSortingTypeSideButton(this, this.grid));
        this.addSideButton(new GridSearchBoxModeSideButton(this));
        this.addSideButton(new GridSizeSideButton(this, this.grid::getSize, this.grid::onSizeChanged));
        if (this.grid.getGridType() == GridType.PATTERN) {
            this.patternScrollbar = new ScrollbarWidget(this, 160, this.getTopHeight() + this.getVisibleRows() * 18 + 4, 6, 52, true);
            this.patternScrollbar.setMaxOffset(24);
            this.patternScrollbar.setOffset(this.patternScrollOffset);
            ((GridContainer)this.field_147002_h).updatePatternSlotPositions(this.patternScrollOffset);
            this.patternScrollbar.addListener((oldOffset, newOffset) -> {
                this.patternScrollOffset = newOffset;
                ((GridContainer)this.field_147002_h).updatePatternSlotPositions(newOffset);
            });
            this.processingPattern = this.addCheckBox(x + 7, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (ITextComponent)new TranslationTextComponent("misc.refinedstorage.processing"), GridTile.PROCESSING_PATTERN.getValue(), btn -> {
                GridTile.PROCESSING_PATTERN.setValue(false, this.processingPattern.func_212942_a());
                ((GridNetworkNode)this.grid).clearMatrix();
                ((GridContainer)this.field_147002_h).initSlots();
                this.patternScrollOffset = 0;
                TileDataManager.setParameter(GridTile.PROCESSING_PATTERN, this.processingPattern.func_212942_a());
            });
            if (!this.processingPattern.func_212942_a()) {
                this.exactPattern = this.addCheckBox(this.processingPattern.field_230690_l_ + this.processingPattern.func_230998_h_() + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (ITextComponent)new TranslationTextComponent("misc.refinedstorage.exact"), GridTile.EXACT_PATTERN.getValue(), btn -> TileDataManager.setParameter(GridTile.EXACT_PATTERN, this.exactPattern.func_212942_a()));
                this.patternScrollbar.setEnabled(false);
            } else {
                this.patternScrollbar.setEnabled(true);
                this.fluidCheckBox = this.addCheckBox(this.processingPattern.field_230690_l_ + this.processingPattern.func_230998_h_() + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (ITextComponent)new TranslationTextComponent("misc.refinedstorage.fluidmode"), ((GridNetworkNode)this.grid).getType() == 1, button -> TileDataManager.setParameter(GridTile.PROCESSING_TYPE, GridTile.PROCESSING_TYPE.getValue() == 0 ? 1 : 0));
            }
        }
        this.updateScrollbar();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void setView(IGridView view) {
        this.view = view;
    }

    public IGridView getView() {
        return this.view;
    }

    @Override
    public void tick(int x, int y) {
        if (this.wasConnected != this.grid.isGridActive()) {
            this.wasConnected = this.grid.isGridActive();
            this.view.sort();
        }
        if (this.updatePatternOffset) {
            this.updatePatternOffsetMax();
            this.updatePatternOffset = false;
        }
        if (GridScreen.isKeyDown(RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX)) {
            RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
        }
        this.tabs.update();
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        if (this.grid.getGridType() == GridType.CRAFTING) {
            return 156;
        }
        if (this.grid.getGridType() == GridType.PATTERN) {
            return 169;
        }
        return 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getTopHeight() + this.getVisibleRows() * 18;
        if (this.grid.getGridType() == GridType.NORMAL || this.grid.getGridType() == GridType.FLUID) {
            yp += 16;
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            yp += 73;
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            yp += 86;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField.func_146179_b();
    }

    @Override
    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_230709_l_ - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.CLIENT_CONFIG.getGrid().getMaxRowsStretch()));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    private boolean isOverSlotWithStack() {
        return this.grid.isGridActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(double mouseX, double mouseY) {
        return RenderUtils.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    private boolean isOverClear(double mouseX, double mouseY) {
        int y = this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getGridType()) {
            case CRAFTING: {
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                if (((GridNetworkNode)this.grid).isProcessingPattern()) {
                    return RenderUtils.inBounds(149, y, 7, 7, mouseX, mouseY);
                }
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(double mouseX, double mouseY) {
        return this.grid.getGridType() == GridType.PATTERN && RenderUtils.inBounds(172, this.getTopHeight() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((GridNetworkNode)this.grid).canCreatePattern();
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.tabs.drawBackground(matrixStack, x, y - this.tabs.getHeight());
        if (this.grid instanceof IPortableGrid) {
            this.bindTexture("refinedstorage", "gui/portable_grid.png");
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            this.bindTexture("refinedstorage", "gui/crafting_grid.png");
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            this.bindTexture("refinedstorage", "gui/pattern_grid" + (((GridNetworkNode)this.grid).isProcessingPattern() ? "_processing" : "") + ".png");
        } else {
            this.bindTexture("refinedstorage", "gui/grid.png");
        }
        int yy = y;
        this.func_238474_b_(matrixStack, x, yy, 0, 0, this.field_146999_f - 34, this.getTopHeight());
        this.func_238474_b_(matrixStack, x + this.field_146999_f - 34 + 4, y, 197, 0, 30, this.grid instanceof IPortableGrid ? 114 : 82);
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            yy += 18;
            int yTextureStart = this.getTopHeight();
            if (i > 0) {
                yTextureStart = i == rows - 1 ? (yTextureStart += 36) : (yTextureStart += 18);
            }
            this.func_238474_b_(matrixStack, x, yy, 0, yTextureStart, this.field_146999_f - 34, 18);
        }
        this.func_238474_b_(matrixStack, x, yy += 18, 0, this.getTopHeight() + 54, this.field_146999_f - 34, this.getBottomHeight());
        if (this.grid.getGridType() == GridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((GridNetworkNode)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.func_238474_b_(matrixStack, x + 172, y + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
            if (this.processingPattern.func_212942_a()) {
                this.updatePatternScrollbar();
                this.patternScrollbar.render(matrixStack);
            }
        }
        this.tabs.drawForeground(matrixStack, x, y - this.tabs.getHeight(), mouseX, mouseY, true);
        this.searchField.func_230430_a_(matrixStack, 0, 0, 0.0f);
        this.scrollbar.render(matrixStack);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.isOverSlotWithStack()) {
            this.drawGridTooltip(matrixStack, this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, this.getYPlayerInventory() - 12, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        int x = 8;
        int y = 19;
        this.slotNumber = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        RenderHelper.func_227784_d_();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                this.slotNumber = slot;
            }
            if (slot < this.view.getStacks().size()) {
                this.view.getStacks().get(slot).draw(matrixStack, this, x, y);
            }
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                int color = this.grid.isGridActive() ? -2130706433 : -10790053;
                matrixStack.func_227860_a_();
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_238468_a_(matrixStack, x, y, x + 16, y + 16, color, color);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                matrixStack.func_227865_b_();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.renderTooltip(matrixStack, mouseX, mouseY, I18n.func_135052_a((String)"misc.refinedstorage.clear", (Object[])new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.renderTooltip(matrixStack, mouseX, mouseY, I18n.func_135052_a((String)"gui.refinedstorage.grid.pattern_create", (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(matrixStack, this.field_230712_o_, mouseX, mouseY);
    }

    private void drawGridTooltip(MatrixStack matrixStack, IGridStack gridStack, int mouseX, int mouseY) {
        List<ITextComponent> textLines = gridStack.getTooltip(true);
        ArrayList smallTextLines = Lists.newArrayList();
        if (!gridStack.isCraftable()) {
            smallTextLines.add(I18n.func_135052_a((String)"misc.refinedstorage.total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}));
        }
        if (gridStack.getTrackerEntry() != null) {
            smallTextLines.add(TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName()));
        }
        ItemStack stack = gridStack instanceof ItemGridStack ? ((ItemGridStack)gridStack).getStack() : ItemStack.field_190927_a;
        RenderUtils.drawTooltipWithSmallText(matrixStack, textLines, smallTextLines, RS.CLIENT_CONFIG.getGrid().getDetailedTooltip(), stack, mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, this.field_230712_o_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int clickedButton) {
        boolean clickedCreatePattern;
        if (this.tabs.mouseClicked()) {
            return true;
        }
        if (this.scrollbar.func_231044_a_(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.grid.getGridType() == GridType.PATTERN && this.patternScrollbar.func_231044_a_(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (RS.CLIENT_CONFIG.getGrid().getPreventSortingWhileShiftIsDown()) {
            this.doSort = !this.isOverSlotArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r) && !this.isOverCraftingOutputArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r);
        if (clickedCreatePattern) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            RS.NETWORK_HANDLER.sendToServer(new GridPatternCreateMessage(((GridNetworkNode)this.grid).getPos()));
            return true;
        }
        if (clickedClear) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
            return true;
        }
        if (this.grid.isGridActive()) {
            ItemStack held = ((GridContainer)this.field_147002_h).getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r) && !held.func_190926_b() && (clickedButton == 0 || clickedButton == 1)) {
                if (this.grid.getGridType() == GridType.FLUID) {
                    RS.NETWORK_HANDLER.sendToServer(new GridFluidInsertHeldMessage());
                } else {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemInsertHeldMessage(clickedButton == 1));
                }
                return true;
            }
            if (this.isOverSlotWithStack()) {
                IGridStack stack = this.view.getStacks().get(this.slotNumber);
                if (held.func_190926_b()) {
                    if (this.view.canCraft() && stack.isCraftable()) {
                        this.field_230706_i_.func_147108_a((Screen)new CraftingSettingsScreen(this, this.field_213127_e.field_70458_d, stack));
                    } else if (this.view.canCraft() && !stack.isCraftable() && stack.getOtherId() != null && GridScreen.func_231173_s_() && GridScreen.func_231172_r_()) {
                        this.field_230706_i_.func_147108_a((Screen)new CraftingSettingsScreen(this, this.field_213127_e.field_70458_d, this.view.get(stack.getOtherId())));
                    } else if (this.grid.getGridType() == GridType.FLUID && held.func_190926_b()) {
                        RS.NETWORK_HANDLER.sendToServer(new GridFluidPullMessage(this.view.getStacks().get(this.slotNumber).getId(), GridScreen.func_231173_s_()));
                    } else if (this.grid.getGridType() != GridType.FLUID) {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GridScreen.func_231173_s_()) {
                            flags |= 4;
                        }
                        RS.NETWORK_HANDLER.sendToServer(new GridItemPullMessage(stack.getId(), flags));
                    }
                }
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, clickedButton);
    }

    private boolean isOverCraftingOutputArea(double mouseX, double mouseY) {
        if (this.grid.getGridType() != GridType.CRAFTING) {
            return false;
        }
        return RenderUtils.inBounds(130, this.getTopHeight() + this.getVisibleRows() * 18 + 18, 24, 24, mouseX, mouseY);
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        if (this.grid.getGridType() == GridType.PATTERN) {
            this.patternScrollbar.func_212927_b(mx, my);
        }
        super.func_212927_b(mx, my);
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        if (this.grid.getGridType() == GridType.PATTERN && this.patternScrollbar.func_231048_c_(mx, my, button)) {
            return true;
        }
        return this.scrollbar.func_231048_c_(mx, my, button) || super.func_231048_c_(mx, my, button);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        if (GridScreen.func_231173_s_() || GridScreen.func_231172_r_()) {
            if (RS.CLIENT_CONFIG.getGrid().getPreventSortingWhileShiftIsDown()) {
                boolean bl = this.doSort = !this.isOverSlotArea(x - (double)this.field_147003_i, y - (double)this.field_147009_r) && !this.isOverCraftingOutputArea(x - (double)this.field_147003_i, y - (double)this.field_147009_r);
            }
            if (this.grid.getGridType() != GridType.FLUID) {
                if (this.isOverInventory(x - (double)this.field_147003_i, y - (double)this.field_147009_r) && this.field_147006_u != null && this.field_147006_u.func_75216_d() && ((GridContainer)this.func_212873_a_()).getDisabledSlotNumber() != this.field_147006_u.getSlotIndex()) {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemInventoryScrollMessage(this.field_147006_u.getSlotIndex(), GridScreen.func_231173_s_(), delta > 0.0));
                } else if (this.isOverSlotArea(x - (double)this.field_147003_i, y - (double)this.field_147009_r)) {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemGridScrollMessage(this.isOverSlotWithStack() ? this.view.getStacks().get(this.slotNumber).getId() : null, GridScreen.func_231173_s_(), delta > 0.0));
                }
            }
            return super.func_231043_a_(x, y, delta);
        }
        if (this.grid.getGridType() == GridType.PATTERN && this.isOverPatternArea(x - (double)this.field_147003_i, y - (double)this.field_147009_r) && this.patternScrollbar.func_231043_a_(x, y, delta)) {
            return true;
        }
        return this.scrollbar.func_231043_a_(x, y, delta) || super.func_231043_a_(x, y, delta);
    }

    private boolean isOverInventory(double x, double y) {
        return RenderUtils.inBounds(8, this.getYPlayerInventory(), 160, 74, x, y);
    }

    private boolean isOverPatternArea(double x, double y) {
        return RenderUtils.inBounds(8, this.getTopHeight() + this.getVisibleRows() * 18, 152, 54, x, y);
    }

    public boolean func_231042_a_(char unknown1, int unknown2) {
        if (this.searchField.func_231042_a_(unknown1, unknown2)) {
            return true;
        }
        return super.func_231042_a_(unknown1, unknown2);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344 || keyCode == 341 || keyCode == 345) {
            this.view.sort();
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.searchField.func_231046_a_(key, scanCode, modifiers) || this.searchField.func_212955_f()) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        if (!RS.CLIENT_CONFIG.getGrid().getRememberSearchQuery()) {
            searchQuery = "";
        }
    }

    public SearchWidget getSearchField() {
        return this.searchField;
    }

    public void updateExactPattern(boolean checked) {
        if (this.exactPattern != null) {
            this.exactPattern.setChecked(checked);
        }
    }

    private void updatePatternOffsetMax() {
        int filledInputSlots = 0;
        int filledOutputSlots = 0;
        int lastFilledInputSlot = 0;
        int lastFilledOutputSlot = 0;
        for (int i = 0; i < 162; ++i) {
            if (this.isMatrixSlotEmpty(i)) continue;
            if (i > 80) {
                ++filledOutputSlots;
                lastFilledOutputSlot = i - 81 - 1;
                continue;
            }
            ++filledInputSlots;
            lastFilledInputSlot = i;
        }
        int maxFilledSlots = Math.max(filledInputSlots, filledOutputSlots);
        int maxLastFilledSlot = Math.max(lastFilledInputSlot, lastFilledOutputSlot);
        int filledSlotOffset = Math.floorDiv(maxFilledSlots - 1, 3);
        int lastSlotOffset = Math.floorDiv(maxLastFilledSlot, 3) - 2;
        this.patternScrollOffsetMax = Math.max(filledSlotOffset, lastSlotOffset);
    }

    private boolean isMatrixSlotEmpty(int slotNumber) {
        return ((GridNetworkNode)this.grid).getProcessingMatrix().getStackInSlot(slotNumber).func_190926_b() && ((GridNetworkNode)this.grid).getProcessingMatrixFluids().getFluid(slotNumber).isEmpty();
    }

    public void updatePatternScrollbar() {
        this.patternScrollbar.setEnabled(this.processingPattern.func_212942_a() && this.patternScrollOffsetMax > 0);
        int oldOffset = this.patternScrollbar.getOffset();
        this.patternScrollbar.setMaxOffset(Math.min(this.patternScrollOffsetMax, 24));
        if (oldOffset != this.patternScrollbar.getOffset()) {
            ((GridContainer)this.field_147002_h).updatePatternSlotPositions(this.patternScrollbar.getOffset());
        }
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    public boolean canSort() {
        return this.doSort || !GridScreen.func_231173_s_() && !GridScreen.func_231172_r_();
    }

    public static List<IGridSorter> getSorters() {
        LinkedList<IGridSorter> sorters = new LinkedList<IGridSorter>();
        sorters.add(GridScreen.getDefaultSorter());
        sorters.add(new QuantityGridSorter());
        sorters.add(new IdGridSorter());
        sorters.add(new LastModifiedGridSorter());
        sorters.add(new InventoryTweaksGridSorter());
        return sorters;
    }

    public static IGridSorter getDefaultSorter() {
        return new NameGridSorter();
    }
}

