/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.item.CoverItem;
import com.refinedmods.refinedstorage.render.model.BakedModelCableCover;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;

public class BakedModelCover
extends BakedModelCableCover {
    private static final LoadingCache<CacheKey, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BakedModelCableCover.addCover(quads, new Cover(key.stack, key.type), Direction.NORTH, key.side, new Random(), null, null, true);
            return quads;
        }
    });
    private ItemStack stack;
    private CoverType type;

    public BakedModelCover(ItemStack stack, CoverType type) {
        super(null);
        this.stack = stack;
        this.type = type;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (this.stack.func_190926_b()) {
            return Collections.emptyList();
        }
        CacheKey key = new CacheKey(state, CoverItem.getItem(this.stack), side, this.type);
        return (List)CACHE.getUnchecked((Object)key);
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(){

            public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return new BakedModelCover(stack, BakedModelCover.this.type);
            }
        };
    }

    @Override
    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack matrixStack) {
        TransformationMatrix transform = (TransformationMatrix)RenderUtils.getDefaultBlockTransforms().get((Object)cameraTransformType);
        if (transform != null) {
            transform.push(matrixStack);
        }
        return this;
    }

    @Override
    public boolean func_177555_b() {
        return true;
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return true;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Override
    public boolean func_230044_c_() {
        return true;
    }

    private class CacheKey {
        private BlockState state;
        private ItemStack stack;
        private Direction side;
        private CoverType type;

        CacheKey(BlockState state, ItemStack stack, Direction side, CoverType type) {
            this.state = state;
            this.stack = stack;
            this.side = side;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return cacheKey.type == this.type && cacheKey.stack.func_77973_b() == this.stack.func_77973_b() && cacheKey.side == this.side && Objects.equals(cacheKey.state, this.state);
        }

        public int hashCode() {
            int result = this.stack.func_77973_b().hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

