/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.IoUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.monitor.CraftingMonitorElementFactory;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingNode;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.factory.FluidStorageDiskFactory;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.factory.ItemStorageDiskFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;

public class CraftingTask
implements ICraftingTask,
NodeListener {
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_ID = "Id";
    private static final String NBT_EXECUTION_STARTED = "ExecutionStarted";
    private static final String NBT_INTERNAL_STORAGE = "InternalStorage";
    private static final String NBT_INTERNAL_FLUID_STORAGE = "InternalFluidStorage";
    private static final String NBT_TO_EXTRACT_INITIAL = "ToExtractInitial";
    private static final String NBT_TO_EXTRACT_INITIAL_FLUIDS = "ToExtractInitialFluids";
    private static final String NBT_CRAFTS = "Crafts";
    private static final String NBT_TOTAL_STEPS = "TotalSteps";
    private static final String NBT_CURRENT_STEP = "CurrentStep";
    private final IStorageDisk<ItemStack> internalStorage;
    private final IStorageDisk<FluidStack> internalFluidStorage;
    private final INetwork network;
    private final ICraftingRequestInfo requested;
    private final int quantity;
    private final ICraftingPattern pattern;
    private final UUID id;
    private final NodeList nodes;
    private final IStackList<ItemStack> toExtractInitial;
    private final IStackList<FluidStack> toExtractInitialFluids;
    private int ticks;
    private long startTime = -1L;
    private int totalSteps;
    private int currentStep;
    private final CraftingMonitorElementFactory craftingMonitorElementFactory = new CraftingMonitorElementFactory();

    public CraftingTask(INetwork network, ICraftingRequestInfo requested, int quantity, ICraftingPattern pattern, NodeList nodes, IStackList<ItemStack> toExtractInitial, IStackList<FluidStack> toExtractInitialFluids) {
        this.network = network;
        this.requested = requested;
        this.quantity = quantity;
        this.pattern = pattern;
        this.id = UUID.randomUUID();
        this.nodes = nodes;
        this.internalStorage = new ItemStorageDisk(null, -1, null);
        this.internalFluidStorage = new FluidStorageDisk(null, -1, null);
        this.toExtractInitial = toExtractInitial;
        this.toExtractInitialFluids = toExtractInitialFluids;
    }

    public CraftingTask(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.network = network;
        this.requested = API.instance().createCraftingRequestInfo(tag.func_74775_l(NBT_REQUESTED));
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.pattern = SerializationUtil.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.id = tag.func_186857_a(NBT_ID);
        this.nodes = new NodeList();
        this.ticks = tag.func_74762_e(NBT_TICKS);
        this.startTime = tag.func_74763_f(NBT_EXECUTION_STARTED);
        this.totalSteps = tag.func_74762_e(NBT_TOTAL_STEPS);
        this.currentStep = tag.func_74762_e(NBT_CURRENT_STEP);
        this.internalStorage = new ItemStorageDiskFactory().createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_STORAGE));
        this.internalFluidStorage = new FluidStorageDiskFactory().createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_FLUID_STORAGE));
        this.toExtractInitial = SerializationUtil.readItemStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL, 10));
        this.toExtractInitialFluids = SerializationUtil.readFluidStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL_FLUIDS, 10));
        ListNBT nodeList = tag.func_150295_c(NBT_CRAFTS, 10);
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = Node.fromNbt(network, nodeList.func_150305_b(i));
            this.nodes.put(node.getPattern(), node);
        }
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_218657_a(NBT_REQUESTED, (INBT)this.requested.writeToNbt());
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_218657_a(NBT_PATTERN, (INBT)SerializationUtil.writePatternToNbt(this.pattern));
        tag.func_74768_a(NBT_TICKS, this.ticks);
        tag.func_186854_a(NBT_ID, this.id);
        tag.func_74772_a(NBT_EXECUTION_STARTED, this.startTime);
        tag.func_218657_a(NBT_INTERNAL_STORAGE, (INBT)this.internalStorage.writeToNbt());
        tag.func_218657_a(NBT_INTERNAL_FLUID_STORAGE, (INBT)this.internalFluidStorage.writeToNbt());
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL, (INBT)SerializationUtil.writeItemStackList(this.toExtractInitial));
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL_FLUIDS, (INBT)SerializationUtil.writeFluidStackList(this.toExtractInitialFluids));
        tag.func_74768_a(NBT_TOTAL_STEPS, this.totalSteps);
        tag.func_74768_a(NBT_CURRENT_STEP, this.currentStep);
        ListNBT nodeList = new ListNBT();
        for (Node node : this.nodes.all()) {
            nodeList.add((Object)node.writeToNbt());
        }
        tag.func_218657_a(NBT_CRAFTS, (INBT)nodeList);
        return tag;
    }

    @Override
    public void start() {
        this.nodes.all().forEach(node -> {
            this.totalSteps += node.getQuantity();
            node.onCalculationFinished();
        });
        this.startTime = System.currentTimeMillis();
        IoUtil.extractItemsFromNetwork(this.toExtractInitial, this.network, this.internalStorage);
        IoUtil.extractFluidsFromNetwork(this.toExtractInitialFluids, this.network, this.internalFluidStorage);
    }

    @Override
    public int getCompletionPercentage() {
        if (this.totalSteps == 0) {
            return 0;
        }
        return (int)((float)this.currentStep * 100.0f / (float)this.totalSteps);
    }

    @Override
    public boolean update() {
        ++this.ticks;
        if (this.nodes.isEmpty()) {
            ItemStack remainder;
            ArrayList<Runnable> toPerform = new ArrayList<Runnable>();
            for (ItemStack stack : this.internalStorage.getStacks()) {
                remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
                toPerform.add(() -> this.internalStorage.extract(stack, stack.func_190916_E() - remainder.func_190916_E(), 1, Action.PERFORM));
            }
            for (ItemStack stack : this.internalFluidStorage.getStacks()) {
                remainder = this.network.insertFluid((FluidStack)stack, stack.getAmount(), Action.PERFORM);
                toPerform.add(() -> this.lambda$update$2((FluidStack)stack, (FluidStack)remainder));
            }
            toPerform.forEach(Runnable::run);
            return this.internalStorage.getStacks().isEmpty() && this.internalFluidStorage.getStacks().isEmpty();
        }
        IoUtil.extractItemsFromNetwork(this.toExtractInitial, this.network, this.internalStorage);
        IoUtil.extractFluidsFromNetwork(this.toExtractInitialFluids, this.network, this.internalFluidStorage);
        for (Node node : this.nodes.all()) {
            node.update(this.network, this.ticks, this.nodes, this.internalStorage, this.internalFluidStorage, this);
        }
        this.nodes.removeMarkedForRemoval();
        return false;
    }

    @Override
    public void onCancelled() {
        this.nodes.unlockAll(this.network);
        for (ItemStack remainder : this.internalStorage.getStacks()) {
            this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
        }
        for (ItemStack remainder : this.internalFluidStorage.getStacks()) {
            this.network.insertFluid((FluidStack)remainder, remainder.getAmount(), Action.PERFORM);
        }
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public ICraftingRequestInfo getRequested() {
        return this.requested;
    }

    @Override
    public int onTrackedInsert(ItemStack stack, int size) {
        for (Node node : this.nodes.all()) {
            ProcessingNode processing;
            int needed;
            if (!(node instanceof ProcessingNode) || (needed = (processing = (ProcessingNode)node).getNeeded(stack)) <= 0) continue;
            if (needed > size) {
                needed = size;
            }
            processing.markReceived(stack, needed);
            size -= needed;
            if (!processing.isRoot()) {
                this.internalStorage.insert(stack, needed, Action.PERFORM);
            } else {
                ItemStack remainder = this.network.insertItem(stack, needed, Action.PERFORM);
                this.internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
            }
            this.network.getCraftingManager().onTaskChanged();
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public int onTrackedInsert(FluidStack stack, int size) {
        for (Node node : this.nodes.all()) {
            ProcessingNode processing;
            int needed;
            if (!(node instanceof ProcessingNode) || (needed = (processing = (ProcessingNode)node).getNeeded(stack)) <= 0) continue;
            if (needed > size) {
                needed = size;
            }
            processing.markReceived(stack, needed);
            size -= needed;
            if (!processing.isRoot()) {
                this.internalFluidStorage.insert(stack, needed, Action.PERFORM);
            } else {
                FluidStack remainder = this.network.insertFluid(stack, needed, Action.PERFORM);
                this.internalFluidStorage.insert(remainder, remainder.getAmount(), Action.PERFORM);
            }
            this.network.getCraftingManager().onTaskChanged();
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        return this.craftingMonitorElementFactory.getElements(this.nodes.all(), this.internalStorage, this.internalFluidStorage);
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void onAllDone(Node node) {
        this.nodes.remove(node);
    }

    @Override
    public void onSingleDone(Node node) {
        ++this.currentStep;
        this.network.getCraftingManager().onTaskChanged();
    }

    private /* synthetic */ void lambda$update$2(FluidStack stack, FluidStack remainder) {
        this.internalFluidStorage.extract(stack, stack.getAmount() - remainder.getAmount(), 1, Action.PERFORM);
    }
}

