/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.StoveTileEntity;
import vectorwing.farmersdelight.utils.ItemUtils;
import vectorwing.farmersdelight.utils.MathUtils;

public class StoveBlock
extends HorizontalBlock {
    public static final DamageSource STOVE_DAMAGE = new DamageSource("farmersdelight.stove").func_76361_j();
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public StoveBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        ItemStack heldStack = player.func_184586_b(handIn);
        Item heldItem = heldStack.func_77973_b();
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (heldStack.getToolTypes().contains(ToolType.SHOVEL)) {
                this.extinguish(state, worldIn, pos);
                heldStack.func_222118_a(1, (LivingEntity)player, action -> action.func_213334_d(handIn));
                return ActionResultType.SUCCESS;
            }
            if (heldItem == Items.field_151131_as) {
                if (!worldIn.func_201670_d()) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, worldIn, pos);
                if (!player.func_184812_l_()) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                worldIn.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
                heldStack.func_222118_a(1, (LivingEntity)player, action -> action.func_213334_d(handIn));
                return ActionResultType.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        if ((tileEntity = worldIn.func_175625_s(pos)) instanceof StoveTileEntity) {
            StoveTileEntity stoveEntity = (StoveTileEntity)tileEntity;
            int stoveSlot = stoveEntity.getNextEmptySlot();
            if (stoveSlot < 0 || stoveEntity.isStoveBlockedAbove()) {
                return ActionResultType.PASS;
            }
            Optional<CampfireCookingRecipe> recipe = stoveEntity.getMatchingRecipe((IInventory)new Inventory(new ItemStack[]{heldStack}), stoveSlot);
            if (recipe.isPresent()) {
                if (!worldIn.field_72995_K && stoveEntity.addItem(player.field_71075_bZ.field_75098_d ? heldStack.func_77946_l() : heldStack, recipe.get(), stoveSlot)) {
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }

    public void extinguish(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        worldIn.func_184134_a(x, y, z, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f, false);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        boolean isLit = (Boolean)worldIn.func_180495_p(pos).func_177229_b((Property)LIT);
        if (isLit && !entityIn.func_230279_az_() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(STOVE_DAMAGE, 1.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof StoveTileEntity) {
                ItemUtils.dropItems(worldIn, pos, (IItemHandler)((StoveTileEntity)tileEntity).getInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT, field_185512_D});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.func_177229_b((Property)HorizontalBlock.field_185512_D);
            Direction.Axis direction$axis = direction.func_176740_k();
            double horizontalOffset = rand.nextDouble() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : horizontalOffset;
            double yOffset = rand.nextDouble() * 6.0 / 16.0;
            double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : horizontalOffset;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.STOVE_TILE.get()).func_200968_a();
    }
}

