/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpelunkerCaveFinder
extends ItemBase {
    private static final int COOLDOWN = 12;
    private static final int RANGE = 64;

    public SpelunkerCaveFinder(Item.Properties properties) {
        super(properties.func_200918_c(10));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        if (direction == null) {
            return super.func_195939_a(context);
        }
        World worldObj = context.func_195991_k();
        boolean found = false;
        BlockPos current = pos;
        for (int i = 1; i <= 64; ++i) {
            current = current.func_177972_a(direction.func_176734_d());
            if (context.func_195991_k().func_175623_d(current)) {
                UtilChat.addChatMessage(player, UtilChat.lang("tool.spelunker.cave") + i);
                found = true;
            } else if (worldObj.func_180495_p(current) == Blocks.field_150355_j.func_176223_P()) {
                UtilChat.addChatMessage(player, UtilChat.lang("tool.spelunker.water") + i);
                found = true;
            } else if (worldObj.func_180495_p(current) == Blocks.field_150353_l.func_176223_P()) {
                UtilChat.addChatMessage(player, UtilChat.lang("tool.spelunker.lava") + i);
                found = true;
            }
            if (found) break;
        }
        if (!found) {
            UtilChat.addChatMessage(player, UtilChat.lang("tool.spelunker.none") + 64);
        }
        UtilItemStack.damageItem((LivingEntity)player, stack);
        UtilEntity.setCooldownItem(player, this, 12);
        return super.func_195939_a(context);
    }
}

