/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilParticle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantTraveller
extends EnchantBase {
    public static final List<String> PROTS = Arrays.asList("sting", DamageSource.field_188406_j.field_76373_n, DamageSource.field_76367_g.field_76373_n, DamageSource.field_220302_v.field_76373_n);
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "traveler";

    public EnchantTraveller(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EnderTeleportEvent event) {
        int level = this.getCurrentArmorLevelSlot(event.getEntityLiving(), EquipmentSlotType.LEGS);
        if (level > 0) {
            event.setAttackDamage(0.0f);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingDamageEvent event) {
        int level = this.getCurrentArmorLevelSlot(event.getEntityLiving(), EquipmentSlotType.LEGS);
        if (level > 0 && PROTS.contains(event.getSource().field_76373_n)) {
            event.setAmount(0.1f);
        }
        if (level > 0 && event.getSource() == DamageSource.field_76379_h) {
            if (event.getEntityLiving().field_70143_R <= 8.0f) {
                event.setAmount(0.1f);
            } else if (event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ElytraItem && event.getAmount() > event.getEntityLiving().func_110143_aJ() - 0.5f) {
                event.setAmount(event.getEntityLiving().func_110143_aJ() - 1.0f);
                UtilParticle.spawnParticle(event.getEntity().field_70170_p, (IParticleData)ParticleTypes.field_218418_af, event.getEntity().func_233580_cy_(), 4);
            }
        }
    }
}

