/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundrecord;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.soundrecord.ContainerSoundRecorder;
import com.lothrazar.cyclic.capability.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.item.datacard.SoundCard;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSoundRecorder
extends TileEntityBase
implements INamedContainerProvider {
    static final int MAX_SOUNDS = 10;
    private static final String SOUNDAT = "soundat";
    private static final String IGNORED = "ignored";
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.SOUND_DATA.get();
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private NonNullList<String> sounds = NonNullList.func_191197_a((int)10, (Object)"");
    private List<String> ignored = new ArrayList<String>();

    public TileSoundRecorder() {
        super((TileEntityType)TileRegistry.SOUND_RECORDER.get());
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSoundRecorder(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        int i;
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        for (i = 0; i < 10; ++i) {
            if (!tag.func_74764_b(SOUNDAT + i)) continue;
            this.sounds.set(i, (Object)tag.func_74779_i(SOUNDAT + i));
        }
        for (i = 0; i < 1000; ++i) {
            if (!tag.func_74764_b(IGNORED + i)) continue;
            this.ignored.add(tag.func_74779_i(IGNORED + i));
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        int i;
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        for (i = 0; i < 10; ++i) {
            tag.func_74778_a(SOUNDAT + i, (String)this.sounds.get(i));
        }
        for (i = 0; i < this.ignored.size(); ++i) {
            tag.func_74778_a(IGNORED + i, this.ignored.get(i));
        }
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case CLEARALL: {
                this.clearSounds();
                break;
            }
            case IGNORE: {
                this.ignoreSound(value);
                break;
            }
            case SAVE: {
                this.saveSoundToCard(value);
            }
        }
    }

    private void saveSoundToCard(int value) {
        String igme = (String)this.sounds.get(value);
        if (!this.inputSlots.getStackInSlot(0).func_190926_b()) {
            SoundCard.saveSound(this.inputSlots.getStackInSlot(0), igme);
        }
    }

    public void ignoreSound(int value) {
        String igme = (String)this.sounds.get(value);
        if (!this.ignored.contains(igme)) {
            this.ignored.add(igme);
        }
        this.sounds.set(value, (Object)"");
    }

    @Override
    public void setFieldString(int field, String value) {
        if (field < 10) {
            this.sounds.set(field, (Object)value);
        } else {
            ModCyclic.LOGGER.error("Invalid string " + field + value);
        }
    }

    @Override
    public String getFieldString(int field) {
        if (field < 10) {
            return (String)this.sounds.get(field);
        }
        return "";
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void clearSounds() {
        this.sounds = NonNullList.func_191197_a((int)10, (Object)"");
    }

    public boolean onSoundHeard(String soundIn) {
        if (soundIn != null && !this.sounds.contains((Object)soundIn) && !this.ignored.contains(soundIn)) {
            int found = -1;
            for (int i = 0; i < 10; ++i) {
                if (!((String)this.sounds.get(i)).isEmpty()) continue;
                found = i;
                break;
            }
            if (found > -1) {
                this.sounds.set(found, (Object)soundIn);
                return true;
            }
        }
        return false;
    }

    static enum Fields {
        CLEARALL,
        IGNORE,
        SAVE;

    }
}

