/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.block.cable.fluid.ContainerCableFluid;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableFluid
extends TileCableBase
implements ITickableTileEntity,
INamedContainerProvider {
    final ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    public static final int CAPACITY = 16000;
    public static final int FLOW_RATE = 16000;
    public static final int EXTRACT_RATE = 16000;
    private final FluidTank fluidTank = new FluidTankBase(this, 16000, fluidStack -> FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), fluidStack));
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidTank);
    private final Map<Direction, LazyOptional<IFluidHandler>> fluidCapSides = new HashMap<Direction, LazyOptional<IFluidHandler>>();

    public TileCableFluid() {
        super(TileRegistry.fluid_pipeTile);
    }

    @Override
    public void updateConnection(Direction side, EnumConnectType connectType) {
        EnumConnectType oldConnectType = this.connectTypeMap.computeIfAbsent(side, k -> (EnumConnectType)((Object)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(k)))));
        if (connectType == EnumConnectType.BLOCKED && oldConnectType != EnumConnectType.BLOCKED) {
            this.fluidCapSides.computeIfPresent(side, (k, v) -> {
                v.invalidate();
                return null;
            });
        } else if (oldConnectType == EnumConnectType.BLOCKED && connectType != EnumConnectType.BLOCKED) {
            this.fluidCapSides.put(side, (LazyOptional<IFluidHandler>)LazyOptional.of(() -> this.fluidTank));
        }
        super.updateConnection(side, connectType);
    }

    public void func_73660_a() {
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = this.getConnectionType(extractSide);
            if (!connection.isExtraction()) continue;
            this.tryExtract(extractSide);
        }
        this.normalFlow();
    }

    private void tryExtract(Direction extractSide) {
        Direction incomingSide;
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        IFluidHandler tankTarget = UtilFluid.getTank(this.field_145850_b, target, incomingSide = extractSide.func_176734_d());
        if (tankTarget != null && tankTarget.getTanks() > 0 && !FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), tankTarget.getFluidInTank(0))) {
            return;
        }
        if (UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, tankTarget, 16000)) {
            return;
        }
        if (!this.fluidCapSides.containsKey(extractSide)) {
            LazyOptional hax = LazyOptional.of(() -> this.fluidTank);
            this.fluidCapSides.put(extractSide, (LazyOptional<IFluidHandler>)hax);
        }
        IFluidHandler tank = (IFluidHandler)this.fluidCapSides.get(extractSide).orElse(null);
        if (this.fluidTank.getSpace() > -1000) {
            UtilFluid.extractSourceWaterloggedCauldron(this.field_145850_b, target, tank);
        }
    }

    private void normalFlow() {
        for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
            EnumConnectType connection = this.getConnectionType(outgoingSide);
            if (connection.isExtraction() || connection.isBlocked()) continue;
            this.moveFluids(outgoingSide, this.field_174879_c.func_177972_a(outgoingSide), 16000, (IFluidHandler)this.fluidTank);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.fluidCap.cast();
            }
            if (this.fluidCapSides.containsKey(side)) {
                LazyOptional<IFluidHandler> sidedCap = this.fluidCapSides.get(side);
                return sidedCap.cast();
            }
            LazyOptional fluidCapSide = this.fluidCapSides.computeIfAbsent(side, k -> {
                if (this.getConnectionType((Direction)k) != EnumConnectType.BLOCKED) {
                    LazyOptional v = LazyOptional.of(() -> this.fluidTank);
                    this.fluidCapSides.put((Direction)k, (LazyOptional<IFluidHandler>)v);
                    return v;
                }
                return LazyOptional.empty();
            });
            if (fluidCapSide != null) {
                return fluidCapSide.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        for (LazyOptional<IFluidHandler> sidedCap : this.fluidCapSides.values()) {
            sidedCap.invalidate();
        }
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        this.fluidTank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_218657_a("fluid", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

