/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.block.render.CustomBlockModels;
import com.simibubi.create.foundation.item.render.CustomItemModels;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.IEventBus;

public class ModelSwapper {
    protected CustomBlockModels customBlockModels = new CustomBlockModels();
    protected CustomItemModels customItemModels = new CustomItemModels();
    protected CustomRenderedItems customRenderedItems = new CustomRenderedItems();

    public CustomBlockModels getCustomBlockModels() {
        return this.customBlockModels;
    }

    public CustomItemModels getCustomItemModels() {
        return this.customItemModels;
    }

    public CustomRenderedItems getCustomRenderedItems() {
        return this.customRenderedItems;
    }

    public void onModelRegistry(ModelRegistryEvent event) {
        this.customRenderedItems.forEach((item, modelFunc) -> ((CustomRenderedItemModel)((Object)((Object)modelFunc.apply(null)))).getModelLocations().forEach(ModelLoader::addSpecialModel));
    }

    public void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        this.customBlockModels.forEach((block, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, ModelSwapper.getAllBlockStateModelLocations(block), modelFunc));
        this.customItemModels.forEach((item, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), modelFunc));
        this.customRenderedItems.forEach((item, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), (IBakedModel m) -> {
            CustomRenderedItemModel swapped = (CustomRenderedItemModel)((Object)((Object)((Object)modelFunc.apply(m))));
            swapped.loadPartials(event);
            return swapped;
        }));
    }

    public void registerListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onModelRegistry);
        modEventBus.addListener(this::onModelBake);
    }

    public static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<IBakedModel, T> factory) {
        locations.forEach(location -> ModelSwapper.swapModels(modelRegistry, location, factory));
    }

    public static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, Function<IBakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (IBakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        ResourceLocation blockRl = block.getRegistryName();
        block.func_176194_O().func_177619_a().forEach(state -> models.add(BlockModelShapes.func_209553_a((ResourceLocation)blockRl, (BlockState)state)));
        return models;
    }

    public static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), "inventory");
    }
}

