/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreenList;
import com.simibubi.create.foundation.config.ui.HintableTextFieldWidget;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.BoxWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class ConfigModListScreen
extends ConfigScreen {
    ConfigScreenList list;
    HintableTextFieldWidget search;
    BoxWidget goBack;
    List<ModEntry> allEntries;

    public ConfigModListScreen(Screen parent) {
        super(parent);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.list.tick();
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        int listWidth = Math.min(this.field_230708_k_ - 80, 300);
        this.list = new ConfigScreenList(this.field_230706_i_, listWidth, this.field_230709_l_ - 60, 15, this.field_230709_l_ - 45, 40);
        this.list.func_230959_g_(this.field_230708_k_ / 2 - this.list.getWidth() / 2);
        this.field_230705_e_.add(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        ModList.get().getMods().stream().map(ModInfo::getModId).forEach(id -> this.allEntries.add(new ModEntry((String)id, this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.field_230693_o_ ? 1 : 0) - (e1.button.field_230693_o_ ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.func_231039_at__().clear();
        this.list.func_231039_at__().addAll(this.allEntries);
        this.goBack = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - listWidth / 2 - 30, this.field_230709_l_ / 2 + 65, 20, 20).withPadding(2.0f, 2.0f))).withCallback(this::func_231175_as__));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((ITextComponent)new StringTextComponent("Go Back"));
        this.widgets.add(this.goBack);
        this.search = new HintableTextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - listWidth / 2, this.field_230709_l_ - 35, listWidth, 20);
        this.search.func_212954_a(this::updateFilter);
        this.search.setHint("Search..");
        this.search.func_146196_d();
        this.widgets.add(this.search);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.list.func_230430_a_(ms, mouseX, mouseY, partialTicks);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ScreenOpener.open(this.parent);
    }

    private void updateFilter(String search) {
        this.list.func_231039_at__().clear();
        this.allEntries.stream().filter(modEntry -> modEntry.id.contains(search.toLowerCase(Locale.ROOT))).forEach(this.list.func_231039_at__()::add);
        this.list.func_230932_a_(this.list.func_230966_l_());
        if (this.list.func_231039_at__().size() > 0) {
            this.search.func_146193_g(Theme.i(Theme.Key.TEXT));
        } else {
            this.search.func_146193_g(Theme.i(Theme.Key.BUTTON_FAIL));
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, Screen parent) {
            super(ConfigScreen.toHumanReadable(id));
            this.id = id;
            this.button = (BoxWidget)((Object)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)AllIcons.I_CONFIG_OPEN.asStencil().at(10.0f, 0.0f)));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else {
                this.button.field_230693_o_ = false;
                this.button.updateColorsFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(new StringTextComponent(ConfigScreen.toHumanReadable(id)));
                this.labelTooltip.addAll(TooltipHelper.cutTextComponent((ITextComponent)new StringTextComponent("This Mod does not have any configs registered or is not using Forge's config system"), TextFormatting.GRAY, TextFormatting.GRAY));
            }
            this.listeners.add(this.button);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void func_230432_a_(MatrixStack ms, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.func_230432_a_(ms, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.field_230690_l_ = x + width - 108;
            this.button.field_230691_m_ = y + 10;
            this.button.setHeight(height - 20);
            this.button.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

