/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"Create/ChunkUtil");
    final EnumSet<Heightmap.Type> POST_FEATURES = EnumSet.of(Heightmap.Type.OCEAN_FLOOR, Heightmap.Type.WORLD_SURFACE, Heightmap.Type.MOTION_BLOCKING, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
    private final List<Long> markedChunks;
    private final List<Long> interestingChunks;

    public ChunkUtil() {
        LOGGER.debug("Chunk Util constructed");
        this.markedChunks = new LinkedList<Long>();
        this.interestingChunks = new LinkedList<Long>();
    }

    public void init() {
        ChunkStatus.field_222617_m = new ChunkStatus("full", ChunkStatus.field_222616_l, 0, this.POST_FEATURES, ChunkStatus.Type.LEVELCHUNK, (_0, _1, _2, _3, _4, future, _6, chunk) -> (CompletableFuture)future.apply(chunk), (_0, _1, _2, _3, future, chunk) -> {
            if (this.markedChunks.contains(chunk.func_76632_l().func_201841_a())) {
                LOGGER.debug("trying to load unforced chunk " + chunk.func_76632_l().toString() + ", returning chunk loading error");
                return ChunkHolder.field_219307_b;
            }
            return (CompletableFuture)future.apply(chunk);
        });
    }

    public boolean reloadChunk(ServerChunkProvider provider, ChunkPos pos) {
        ChunkHolder holder = (ChunkHolder)provider.field_217237_a.field_219251_e.remove(pos.func_201841_a());
        provider.field_217237_a.field_219262_p = true;
        if (holder != null) {
            provider.field_217237_a.field_219253_g.put(pos.func_201841_a(), (Object)holder);
            provider.field_217237_a.func_219212_a(pos.func_201841_a(), holder);
            return true;
        }
        return false;
    }

    public boolean unloadChunk(ServerChunkProvider provider, ChunkPos pos) {
        this.interestingChunks.add(pos.func_201841_a());
        this.markedChunks.add(pos.func_201841_a());
        return this.reloadChunk(provider, pos);
    }

    public int clear(ServerChunkProvider provider) {
        LinkedList<Long> copy = new LinkedList<Long>(this.markedChunks);
        int size = this.markedChunks.size();
        this.markedChunks.clear();
        copy.forEach(l -> this.reForce(provider, new ChunkPos(l.longValue())));
        return size;
    }

    public void reForce(ServerChunkProvider provider, ChunkPos pos) {
        provider.func_217206_a(pos, true);
        provider.func_217206_a(pos, false);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        if (this.interestingChunks.contains(event.getChunk().func_76632_l().func_201841_a())) {
            LOGGER.info("Interesting Chunk Unload: " + event.getChunk().func_76632_l().toString());
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        ChunkPos pos = event.getChunk().func_76632_l();
        if (this.interestingChunks.contains(pos.func_201841_a())) {
            LOGGER.info("Interesting Chunk Load: " + pos.toString());
            if (!this.markedChunks.contains(pos.func_201841_a())) {
                this.interestingChunks.remove(pos.func_201841_a());
            }
        }
    }
}

