/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;

public class BasinCategory
extends CreateRecipeCategory<BasinRecipe> {
    private boolean needsHeating;

    public BasinCategory(boolean needsHeating, IDrawable icon, IDrawable background) {
        super(icon, background);
        this.needsHeating = needsHeating;
    }

    public Class<? extends BasinRecipe> getRecipeClass() {
        return BasinRecipe.class;
    }

    public void setIngredients(BasinRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> itemIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            itemIngredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllBlocks.BLAZE_BURNER.get()}));
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            itemIngredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllItems.BLAZE_CAKE.get()}));
        }
        ingredients.setInputIngredients(itemIngredients);
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, BasinRecipe recipe, IIngredients iingredients) {
        int j;
        int i;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        NonNullList<FluidIngredient> fluidIngredients = recipe.getFluidIngredients();
        List<Pair<Ingredient, MutableInt>> ingredients = ItemHelper.condenseIngredients(recipe.func_192400_c());
        List<ItemStack> itemOutputs = recipe.getRollableResultsAsItemStacks();
        NonNullList<FluidStack> fluidOutputs = recipe.getFluidResults();
        int size = ingredients.size() + fluidIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int yOffset = 0;
        for (i = 0; i < ingredients.size(); ++i) {
            itemStacks.init(i, true, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19 + yOffset);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            Pair<Ingredient, MutableInt> pair = ingredients.get(i);
            Ingredient ingredient = pair.getFirst();
            MutableInt amount = pair.getSecond();
            for (ItemStack itemStack : ingredient.func_193365_a()) {
                ItemStack stack = itemStack.func_77946_l();
                stack.func_190920_e(amount.getValue().intValue());
                stacks.add(stack);
            }
            itemStacks.set(i, stacks);
        }
        for (j = 0; j < fluidIngredients.size(); ++j) {
            int i2 = i + j;
            fluidStacks.init(j, true, 17 + xOffset + i2 % 3 * 19, 51 - i2 / 3 * 19 + yOffset);
            List<FluidStack> stacks = ((FluidIngredient)fluidIngredients.get(j)).getMatchingFluidStacks();
            fluidStacks.set(j, BasinCategory.withImprovedVisibility(stacks));
        }
        int outSize = fluidOutputs.size() + recipe.getRollableResults().size();
        int outputIndex = 0;
        if (!itemOutputs.isEmpty()) {
            BasinCategory.addStochasticTooltip(itemStacks, recipe.getRollableResults(), i);
        }
        while (outputIndex < outSize) {
            int xPosition = 141 - (outSize % 2 != 0 && outputIndex == outSize - 1 ? 0 : (outputIndex % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (outputIndex / 2) + 50 + yOffset;
            if (itemOutputs.size() > outputIndex) {
                itemStacks.init(i, false, xPosition, yPosition + yOffset);
                itemStacks.set(i, itemOutputs.get(outputIndex));
                ++i;
            } else {
                fluidStacks.init(j, false, xPosition + 1, yPosition + 1 + yOffset);
                fluidStacks.set(j, BasinCategory.withImprovedVisibility((FluidStack)fluidOutputs.get(outputIndex - itemOutputs.size())));
                ++j;
            }
            ++outputIndex;
        }
        BasinCategory.addFluidTooltip(fluidStacks, fluidIngredients, fluidOutputs);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            itemStacks.init(i, true, 133, 80);
            itemStacks.set(i, AllBlocks.BLAZE_BURNER.asStack());
            ++i;
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            itemStacks.init(i, true, 152, 80);
            itemStacks.set(i, AllItems.BLAZE_CAKE.asStack());
            ++i;
        }
    }

    public void draw(BasinRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        List<Pair<Ingredient, MutableInt>> actualIngredients = ItemHelper.condenseIngredients(recipe.func_192400_c());
        int size = actualIngredients.size() + recipe.getFluidIngredients().size();
        int outSize = recipe.getFluidResults().size() + recipe.getRollableResults().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        int yOffset = 0;
        for (int i = 0; i < size; ++i) {
            AllGuiTextures.JEI_SLOT.draw(matrixStack, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19 + yOffset);
        }
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + outSize) / 2;
        for (int i = 0; i < outSize; ++i) {
            AllGuiTextures.JEI_SLOT.draw(matrixStack, 141 - (outSize % 2 != 0 && i == outSize - 1 ? 0 : (i % 2 == 0 ? 10 : -9)), -19 * (i / 2) + 50 + yOffset);
        }
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.draw(matrixStack, 136, -19 * (vRows - 1) + 32 + yOffset);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.draw(matrixStack, 81, 58 + (noHeat ? 10 : 30));
        if (!this.needsHeating) {
            return;
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.draw(matrixStack, 4, 80);
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)Lang.translate(requiredHeat.getTranslationKey(), new Object[0]), 9.0f, 86.0f, requiredHeat.getColor());
    }
}

