/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosSelectorOptions {
    public static void register() {
        EntityOptions.func_202024_a((String)"curios", CuriosSelectorOptions::curioArgument, entitySelectorParser -> true, (ITextComponent)new TranslationTextComponent("argument.entity.options.curios.description"));
    }

    private static void curioArgument(EntitySelectorParser parser) throws CommandSyntaxException {
        ItemStack stack;
        StringReader reader = parser.func_197398_f();
        boolean invert = parser.func_197378_e();
        CompoundNBT compoundtag = new JsonToNBT(reader).func_193593_f();
        ListNBT listTag = compoundtag.func_150295_c("slot", 8);
        HashSet<String> slots = new HashSet<String>();
        for (int i = 0; i < listTag.size(); ++i) {
            slots.add(listTag.func_150307_f(i));
        }
        listTag = compoundtag.func_150295_c("index", 3);
        int min = 0;
        int max = -1;
        if (listTag.size() == 2) {
            min = Math.max(0, listTag.func_186858_c(0));
            max = Math.max(min + 1, listTag.func_186858_c(1));
        }
        ItemStack itemStack = stack = compoundtag.func_74764_b("item") ? ItemStack.func_199557_a((CompoundNBT)compoundtag.func_74775_l("item")) : null;
        if (stack != null) {
            stack.func_190920_e(Math.max(1, stack.func_190916_E()));
        }
        boolean exclusive = compoundtag.func_74767_n("exclusive");
        int finalMin = min;
        int finalMax = max;
        parser.func_197401_a(entity -> CuriosSelectorOptions.matches(entity, slots, finalMin, finalMax, stack, invert, exclusive));
    }

    private static boolean matches(Entity entity, Set<String> slots, int min, int max, ItemStack stack, boolean invert, boolean exclusive) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> {
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                if (stack != null) {
                    if (exclusive) {
                        return CuriosSelectorOptions.hasOnlyItem(curios, slots, min, max, stack, invert);
                    }
                    return CuriosSelectorOptions.hasItem(curios, slots, min, max, stack, invert);
                }
                if (!slots.isEmpty()) {
                    if (exclusive) {
                        return CuriosSelectorOptions.hasOnlySlot(curios, slots, max, invert);
                    }
                    return CuriosSelectorOptions.hasSlot(curios, slots, max, invert);
                }
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static boolean hasOnlySlot(Map<String, ICurioStacksHandler> curios, Set<String> slots, int max, boolean invert) {
        boolean foundSlot = false;
        if (invert) {
            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                if (slots.contains(entry.getKey()) && (max == -1 || entry.getValue().getSlots() >= max)) {
                    foundSlot = true;
                    continue;
                }
                if (!foundSlot) continue;
                return true;
            }
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (slots.contains(entry.getKey()) && (max == -1 || entry.getValue().getSlots() >= max)) {
                foundSlot = true;
                continue;
            }
            if (!foundSlot) continue;
            return false;
        }
        return foundSlot;
    }

    private static boolean hasSlot(Map<String, ICurioStacksHandler> curios, Set<String> slots, int max, boolean invert) {
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!slots.contains(entry.getKey()) || max != -1 && entry.getValue().getSlots() < max) continue;
            return !invert;
        }
        return invert;
    }

    private static boolean hasOnlyItem(Map<String, ICurioStacksHandler> curios, Set<String> slots, int min, int max, ItemStack stack, boolean invert) {
        boolean foundItem = false;
        if (invert) {
            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                if (!slots.isEmpty() && !slots.contains(entry.getKey())) continue;
                ICurioStacksHandler stacks = entry.getValue();
                int limit = max == -1 ? stacks.getSlots() : Math.min(stacks.getSlots(), max);
                for (int i = min; i < limit; ++i) {
                    ItemStack current = stacks.getStacks().getStackInSlot(i);
                    if (ItemStack.func_77989_b((ItemStack)current, (ItemStack)stack)) {
                        foundItem = true;
                        continue;
                    }
                    if (!foundItem) continue;
                    return true;
                }
            }
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!slots.isEmpty() && !slots.contains(entry.getKey())) continue;
            ICurioStacksHandler stacks = entry.getValue();
            int limit = max == -1 ? stacks.getSlots() : Math.min(stacks.getSlots(), max);
            for (int i = min; i < limit; ++i) {
                ItemStack current = stacks.getStacks().getStackInSlot(i);
                if (ItemStack.func_77989_b((ItemStack)current, (ItemStack)stack)) {
                    foundItem = true;
                    continue;
                }
                if (!foundItem) continue;
                return false;
            }
        }
        return foundItem;
    }

    private static boolean hasItem(Map<String, ICurioStacksHandler> curios, Set<String> slots, int min, int max, ItemStack stack, boolean invert) {
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!slots.isEmpty() && !slots.contains(entry.getKey())) continue;
            ICurioStacksHandler stacks = entry.getValue();
            int limit = max == -1 ? stacks.getSlots() : Math.min(stacks.getSlots(), max);
            for (int i = min; i < limit; ++i) {
                ItemStack current = stacks.getStacks().getStackInSlot(i);
                if (!ItemStack.func_77989_b((ItemStack)current, (ItemStack)stack)) continue;
                return !invert;
            }
        }
        return invert;
    }
}

