/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import elucent.eidolon.Eidolon;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.spell.KnowledgeUtil;
import elucent.eidolon.spell.Sign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_index_page.png");
    IndexEntry[] entries;

    public IndexPage(IndexEntry ... pages) {
        super(BACKGROUND);
        this.entries = pages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].isUnlocked() || mouseX < x + 2 || mouseX > x + 124 || mouseY < y + 8 + i * 20 || mouseY > y + 26 + i * 20) continue;
            gui.changeChapter(this.entries[i].chapter);
            Minecraft.func_71410_x().field_71439_g.func_213823_a(SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        int i;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        for (i = 0; i < this.entries.length; ++i) {
            gui.func_238474_b_(mStack, x + 1, y + 7 + i * 20, 128, this.entries[i].isUnlocked() ? 0 : 96, 122, 18);
        }
        for (i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].isUnlocked()) continue;
            Minecraft.func_71410_x().func_175599_af().func_180450_b(this.entries[i].icon, x + 2, y + 8 + i * 20);
            String string = I18n.func_135052_a((String)this.entries[i].chapter.titleKey, (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71466_p.getClass();
            IndexPage.drawText(gui, mStack, string, x + 24, y + 20 + i * 20 - 9);
        }
    }

    public static class FactLockedEntry
    extends IndexEntry {
        ResourceLocation[] facts;

        public FactLockedEntry(Chapter chapter, ItemStack icon, ResourceLocation ... facts) {
            super(chapter, icon);
            this.facts = facts;
        }

        @Override
        public boolean isUnlocked() {
            for (ResourceLocation fact : this.facts) {
                if (KnowledgeUtil.knowsFact(Eidolon.proxy.getPlayer(), fact)) continue;
                return false;
            }
            return true;
        }
    }

    public static class SignLockedEntry
    extends IndexEntry {
        Sign[] signs;

        public SignLockedEntry(Chapter chapter, ItemStack icon, Sign ... signs) {
            super(chapter, icon);
            this.signs = signs;
        }

        @Override
        public boolean isUnlocked() {
            for (Sign sign : this.signs) {
                if (KnowledgeUtil.knowsSign(Eidolon.proxy.getPlayer(), sign)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IndexEntry {
        Chapter chapter;
        ItemStack icon;

        public IndexEntry(Chapter chapter, ItemStack icon) {
            this.chapter = chapter;
            this.icon = icon;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean isUnlocked() {
            return true;
        }
    }
}

