/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.ClientEvents;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.KnowledgeProvider;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChantPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_chant_page.png");
    Sign[] chant;
    String text;
    String title;

    public ChantPage(String textKey, Sign ... chant) {
        super(BACKGROUND);
        this.text = textKey;
        this.title = textKey + ".title";
        this.chant = chant;
    }

    @OnlyIn(value=Dist.CLIENT)
    static void colorBlit(MatrixStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, int color) {
        Matrix4f matrix = mStack.func_227866_c_().func_227870_a_();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = ColorUtil.getRed(color);
        int g = ColorUtil.getGreen(color);
        int b = ColorUtil.getBlue(color);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)maxY, 0.0f).func_225583_a_(minU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)maxY, 0.0f).func_225583_a_(maxU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)y, 0.0f).func_225583_a_(maxU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225583_a_(minU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        String title = I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
        int titleWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(title);
        int n = x + 64 - titleWidth / 2;
        Minecraft.func_71410_x().field_71466_p.getClass();
        ChantPage.drawText(gui, mStack, title, n, y + 15 - 9);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CodexGui.CODEX_BACKGROUND);
        ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
        IKnowledge knowledge = (IKnowledge)entity.getCapability(KnowledgeProvider.CAPABILITY, null).resolve().get();
        int w = this.chant.length * 24;
        int baseX = x + 64 - w / 2;
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)(baseX - 16), (int)(y + 28), (float)256.0f, (float)208.0f, (int)16, (int)32, (int)512, (int)512);
        for (int i = 0; i < this.chant.length; ++i) {
            CodexGui.func_238463_a_((MatrixStack)mStack, (int)(baseX + i * 24), (int)(y + 28), (float)272.0f, (float)208.0f, (int)24, (int)32, (int)512, (int)512);
        }
        CodexGui.func_238463_a_((MatrixStack)mStack, (int)(baseX + w), (int)(y + 28), (float)296.0f, (float)208.0f, (int)16, (int)32, (int)512, (int)512);
        Tessellator tess = Tessellator.func_178181_a();
        RenderSystem.enableBlend();
        RenderSystem.alphaFunc((int)518, (float)0.00390625f);
        for (int i = 0; i < this.chant.length; ++i) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CodexGui.CODEX_BACKGROUND);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            CodexGui.func_238463_a_((MatrixStack)mStack, (int)(baseX + i * 24), (int)(y + 28), (float)312.0f, (float)208.0f, (int)24, (int)24, (int)512, (int)512);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Sign sign = this.chant[i];
            float flicker = 0.875f + 0.125f * (float)Math.sin(Math.toRadians(12.0f * ClientEvents.getClientTicks()));
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), baseX + i * 24 + 4, y + 32, 16.0, 16.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(sign.getSprite()));
            tess.func_78381_a();
            RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), baseX + i * 24 + 4, y + 32, 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(sign.getSprite()));
            tess.func_78381_a();
        }
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ChantPage.drawWrappingText(gui, mStack, I18n.func_135052_a((String)this.text, (Object[])new Object[0]), x + 4, y + 72, 120);
    }
}

