/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.screen.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import owmii.lib.client.screen.Texture;

public class IconButton
extends Button {
    protected final Minecraft mc = Minecraft.func_71410_x();
    private Consumer<List<ITextComponent>> tooltipConsumer = stringList -> {};
    private Screen screen;
    private Texture texture;
    private Texture hovering;
    private ItemStack stack;
    private float xOffset;
    private float yOffset;
    @Nullable
    private SoundEvent sound;
    public static final IconButton EMPTY = new IconButton(0, 0, Texture.EMPTY, b -> {}, (Screen)new ChatScreen(""));

    public IconButton(int x, int y, ITextComponent text, Texture texture, Button.IPressable onPress, Screen screen) {
        this(x, y, ItemStack.field_190927_a, texture, Texture.EMPTY, text, onPress, screen);
    }

    public IconButton(int x, int y, ITextComponent text, Texture texture, Button.IPressable onPress, Texture hovering, Screen screen) {
        this(x, y, ItemStack.field_190927_a, texture, hovering, text, onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Button.IPressable onPress, Screen screen) {
        this(x, y, ItemStack.field_190927_a, texture, Texture.EMPTY, (ITextComponent)new StringTextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, Texture texture, Texture hovering, Button.IPressable onPress, Screen screen) {
        this(x, y, ItemStack.field_190927_a, texture, hovering, (ITextComponent)new StringTextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Button.IPressable onPress, Screen screen) {
        this(x, y, stack, texture, Texture.EMPTY, (ITextComponent)new StringTextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, Button.IPressable onPress, Screen screen) {
        this(x, y, stack, texture, hovering, (ITextComponent)new StringTextComponent(""), onPress, screen);
    }

    public IconButton(int x, int y, ItemStack stack, Texture texture, Texture hovering, ITextComponent text, Button.IPressable onPress, Screen screen) {
        super(x, y, texture.getWidth(), texture.getHeight(), text, onPress);
        this.texture = texture;
        this.screen = screen;
        this.hovering = hovering;
        this.stack = stack;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float pt) {
        if (this.field_230694_p_) {
            boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            if (this.field_230692_n_ && !this.hovering.isEmpty()) {
                this.hovering.draw(matrix, this.field_230690_l_, this.field_230691_m_);
            } else {
                this.texture.draw(matrix, this.field_230690_l_, this.field_230691_m_);
            }
            FontRenderer f = this.mc.field_71466_p;
            String s = this.func_230458_i_().getString();
            if (!s.isEmpty()) {
                int width = f.func_78256_a(s);
                Color c = this.func_230458_i_().func_150256_b().func_240711_a_();
                int color = c == null ? 0x555555 : c.func_240742_a_();
                f.func_238421_b_(matrix, s, this.xOffset + (float)this.field_230690_l_ + 0.5f + (float)this.field_230688_j_ / 2.0f - (float)width / 2.0f, this.yOffset + (float)this.field_230691_m_ + (float)this.field_230689_k_ / 2.0f - 4.0f, color);
            }
            if (!this.stack.func_190926_b()) {
                RenderSystem.pushMatrix();
                Minecraft mc = Minecraft.func_71410_x();
                RenderSystem.translated((double)((double)(this.xOffset + (float)this.field_230690_l_) - 8.0 + (double)((float)this.field_230688_j_ / 2.0f)), (double)((double)(this.yOffset + (float)this.field_230691_m_) - 8.0 + (double)((float)this.field_230689_k_ / 2.0f)), (double)0.0);
                mc.func_175599_af().func_180450_b(this.stack, 0, 0);
                RenderSystem.popMatrix();
            }
        }
    }

    public void func_230443_a_(MatrixStack matrix, int mouseX, int mouseY) {
        ArrayList tooltip = new ArrayList();
        this.tooltipConsumer.accept(tooltip);
        if (!tooltip.isEmpty()) {
            this.screen.func_243308_b(matrix, tooltip, mouseX, mouseY);
        }
    }

    public void blit(MatrixStack matrix, Texture texture, int x, int y) {
        this.bindTexture(texture.getLocation());
        this.func_238474_b_(matrix, x, y, texture.getU(), texture.getV(), texture.getWidth(), texture.getHeight());
    }

    public void bindTexture(ResourceLocation guiTexture) {
        this.mc.func_110434_K().func_110577_a(guiTexture);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public IconButton setScreen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public IconButton setTexture(Texture texture) {
        this.texture = texture;
        return this;
    }

    public Texture getHovering() {
        return this.hovering;
    }

    public IconButton setHovering(Texture hovering) {
        this.hovering = hovering;
        return this;
    }

    public Consumer<List<ITextComponent>> getTooltip() {
        return this.tooltipConsumer;
    }

    public IconButton setTooltip(Consumer<List<ITextComponent>> tooltipConsumer) {
        this.tooltipConsumer = tooltipConsumer;
        return this;
    }

    public IconButton setStackInSlot(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public IconButton xOffset(float xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public IconButton yOffset(float yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public void func_230988_a_(SoundHandler handler) {
        if (this.sound != null) {
            handler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.sound, (float)1.0f));
        }
    }

    public IconButton setClickSound() {
        this.sound = SoundEvents.field_187909_gi;
        return this;
    }

    public IconButton setSound(@Nullable SoundEvent sound) {
        this.sound = sound;
        return this;
    }
}

