/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.capability.BackpackCapabilityProvider;
import com.buuz135.industrial.capability.MultipleFluidHandlerScreenProviderItemStack;
import com.buuz135.industrial.container.BackpackContainer;
import com.buuz135.industrial.gui.component.SlotDefinitionGuiAddon;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.proxy.network.BackpackSyncMessage;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemInfinityBackpack
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 0;
    public static int FUEL_CONSUMPTION = 1;
    private static String NBT_MAGNET = "Magnet";
    private static String NBT_PICKUP = "AutoPickUpMode";

    public ItemInfinityBackpack() {
        super("infinity_backpack", (ItemGroup)ModuleTool.TAB_TOOL, new Item.Properties().func_200917_a(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
        EventManager.forge(EntityItemPickupEvent.class).filter(entityItemPickupEvent -> !entityItemPickupEvent.getItem().func_92059_d().func_190926_b()).process(entityItemPickupEvent -> {
            for (PlayerInventoryFinder.Target target : ItemInfinityBackpack.findAllBackpacks(entityItemPickupEvent.getPlayer())) {
                BackpackDataManager.BackpackItemHandler handler;
                BackpackDataManager manager;
                ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(entityItemPickupEvent.getPlayer(), target.getSlot());
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInfinityBackpack) || ItemInfinityBackpack.getPickUpMode(stack) != 1 && ItemInfinityBackpack.getPickUpMode(stack) != 0 || (manager = BackpackDataManager.getData((IWorld)entityItemPickupEvent.getItem().field_70170_p)) == null || !stack.func_196082_o().func_74764_b("Id") || (handler = manager.getBackpack(stack.func_196082_o().func_74779_i("Id"))) == null) continue;
                ItemStack picked = entityItemPickupEvent.getItem().func_92059_d();
                for (int pos = 0; pos < handler.getSlots(); ++pos) {
                    ItemStack slotStack = handler.getSlotDefinition(pos).getStack().func_77946_l();
                    slotStack.func_190920_e(1);
                    if (slotStack.func_190926_b() || !slotStack.getStack().func_77969_a(picked) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)picked)) continue;
                    ItemStack returned = handler.insertItem(pos, picked.func_77946_l(), false);
                    picked.func_190920_e(returned.func_190916_E());
                    entityItemPickupEvent.setResult(Event.Result.ALLOW);
                    if (entityItemPickupEvent.getPlayer() instanceof ServerPlayerEntity) {
                        ItemInfinityBackpack.sync(entityItemPickupEvent.getPlayer().field_70170_p, stack.func_196082_o().func_74779_i("Id"), (ServerPlayerEntity)entityItemPickupEvent.getPlayer());
                    }
                    return;
                }
            }
        }).subscribe();
        EventManager.forge(PlayerXpEvent.PickupXp.class).filter(pickupXp -> pickupXp.getOrb().func_70089_S()).process(pickupXp -> ItemInfinityBackpack.findFirstBackpack(pickupXp.getPlayer()).ifPresent(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(pickupXp.getPlayer(), target.getSlot());
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemInfinityBackpack && (ItemInfinityBackpack.getPickUpMode(stack) == 2 || ItemInfinityBackpack.getPickUpMode(stack) == 0) && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                ExperienceOrbEntity entity = pickupXp.getOrb();
                IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
                if (handlerItem != null && handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), entity.func_70526_d() * 20), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), entity.func_70526_d() * 20), IFluidHandler.FluidAction.EXECUTE);
                    entity.func_70106_y();
                    pickupXp.setCanceled(true);
                }
            }
        })).subscribe();
    }

    public static int getSlotSize(ItemStack stack) {
        InfinityTier braquet = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityBackpack.getPowerFromStack(stack)).getLeft());
        return braquet == InfinityTier.ARTIFACT ? Integer.MAX_VALUE : (int)(2048.0 * Math.pow(8.0, braquet.getRadius()));
    }

    public static void sync(World world, String id, ServerPlayerEntity player) {
        IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackSyncMessage(id, BackpackDataManager.getData((IWorld)world).getBackpack(id).serializeNBT()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean isMagnetEnabled(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(NBT_MAGNET);
    }

    public static void setMagnet(ItemStack stack, boolean enabled) {
        stack.func_196082_o().func_74757_a(NBT_MAGNET, enabled);
    }

    public static int getPickUpMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(NBT_PICKUP);
    }

    public static void setPickUpMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a(NBT_PICKUP, mode);
    }

    public static List<PlayerInventoryFinder.Target> findAllBackpacks(PlayerEntity entity) {
        ArrayList<PlayerInventoryFinder.Target> list = new ArrayList<PlayerInventoryFinder.Target>();
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).func_77973_b() instanceof ItemInfinityBackpack)) continue;
                list.add(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static Optional<PlayerInventoryFinder.Target> findFirstBackpack(PlayerEntity entity) {
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).func_77973_b() instanceof ItemInfinityBackpack)) continue;
                return Optional.of(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new BackpackCapabilityProvider(stack, this.getTankConstructor(stack), this.getEnergyConstructor(stack));
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (player instanceof ServerPlayerEntity) {
            Object id;
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Id")) {
                id = UUID.randomUUID();
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_74778_a("Id", ((UUID)id).toString());
                BackpackDataManager.getData((IWorld)worldIn).createBackPack((UUID)id);
                stack.func_77982_d(nbt);
            }
            id = stack.func_77978_p().func_74779_i("Id");
            IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackOpenedMessage(player.field_71071_by.field_70461_c, PlayerInventoryFinder.MAIN), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            ItemInfinityBackpack.sync(worldIn, (String)id, (ServerPlayerEntity)player);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> LocatorFactory.writePacketBuffer((PacketBuffer)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == Hand.MAIN_HAND)));
            return ActionResult.func_226248_a_((Object)player.func_184586_b(handIn));
        }
        if (CommonProxy.CONTRIBUTORS.contains(player.func_110124_au().toString())) {
            player.func_184586_b(handIn).func_196082_o().func_74757_a("Special", true);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemInfinityBackpack.isMagnetEnabled(stack)) {
            for (ItemEntity itemEntity : entityIn.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226278_cu_(), entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_()).func_186662_g(5.0))) {
                if (entityIn.field_70170_p.field_72995_K) {
                    if (!itemEntity.func_233570_aj_() || worldIn.field_73012_v.nextInt(5) >= 1) continue;
                    itemEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, itemEntity.func_226277_ct_(), itemEntity.func_226278_cu_() + 0.5, itemEntity.func_226281_cx_(), 0.0, -0.5, 0.0);
                    continue;
                }
                if (itemEntity.func_174874_s() || !this.enoughFuel(stack)) continue;
                itemEntity.func_70634_a(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_());
                this.consumeFuel(stack);
            }
        }
        if (!entityIn.field_70170_p.field_72995_K && entityIn instanceof PlayerEntity) {
            BackpackDataManager.BackpackItemHandler handler;
            BackpackDataManager manager;
            FluidStack fluidStack;
            IFluidHandlerItem handlerItem;
            if (this.enoughFuel(stack) && (((PlayerEntity)entityIn).func_71024_bL().func_75121_c() || ((PlayerEntity)entityIn).func_71024_bL().func_75115_e() < 10.0f) && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && (handlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseGet(null)) instanceof MultipleFluidHandlerScreenProviderItemStack && !(fluidStack = handlerItem.getFluidInTank(2)).isEmpty() && fluidStack.getAmount() >= 400) {
                ((MultipleFluidHandlerScreenProviderItemStack)handlerItem).setFluidInTank(2, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), fluidStack.getAmount() - 400));
                ((PlayerEntity)entityIn).func_71024_bL().func_75122_a(1, 1.0f);
                this.consumeFuel(stack);
            }
            if (entityIn.field_70170_p.func_82737_E() % 10L == 0L && (manager = BackpackDataManager.getData((IWorld)entityIn.field_70170_p)) != null && stack.func_196082_o().func_74764_b("Id") && (handler = manager.getBackpack(stack.func_196082_o().func_74779_i("Id"))) != null) {
                if (ItemInfinityBackpack.getSlotSize(stack) != handler.getSlotLimit(0)) {
                    handler.setMaxAmount(ItemInfinityBackpack.getSlotSize(stack));
                }
                if (this.enoughFuel(stack)) {
                    for (int i = 0; i < 32; ++i) {
                        if (handler.getStackInSlot(i).func_190926_b() || !handler.getSlotDefinition(i).isRefillItems()) continue;
                        PlayerInventory inventory = ((PlayerEntity)entityIn).field_71071_by;
                        for (int inv = 0; inv <= 35; ++inv) {
                            ItemStack inventoryStack = inventory.func_70301_a(inv);
                            if (inventoryStack.func_190926_b() || inventoryStack.func_190916_E() >= inventoryStack.func_77976_d() || !handler.isItemValid(i, inventoryStack) || !this.enoughFuel(stack)) continue;
                            int extracting = inventoryStack.func_77976_d() - inventoryStack.func_190916_E();
                            ItemStack extractedSLot = handler.extractItem(i, extracting, false);
                            inventoryStack.func_190920_e(inventoryStack.func_190916_E() + extractedSLot.func_190916_E());
                            if (entityIn instanceof ServerPlayerEntity) {
                                ItemInfinityBackpack.sync(entityIn.field_70170_p, stack.func_196082_o().func_74779_i("Id"), (ServerPlayerEntity)entityIn);
                            }
                            this.consumeFuel(stack);
                            return;
                        }
                    }
                }
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public IFactory<FluidHandlerScreenProviderItemStack> getTankConstructor(ItemStack stack) {
        int y = 88;
        return () -> new MultipleFluidHandlerScreenProviderItemStack(stack, 1000000, new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("biofuel", -21, y + 0, fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.BIOFUEL.getSourceFluid()), false, true, FluidTankComponent.Type.SMALL), new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("essence", -21, y + 25, fluidStack -> fluidStack.getFluid().func_207185_a(IndustrialTags.Fluids.EXPERIENCE), true, true, FluidTankComponent.Type.SMALL), new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("meat", -21, y + 50, fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.MEAT.getSourceFluid()), false, true, FluidTankComponent.Type.SMALL));
    }

    @Override
    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(InfinityTier.ARTIFACT.getPowerNeeded(), -21, 24){

            @Override
            public long getLongEnergyStored() {
                if (stack.func_77942_o()) {
                    return Math.min(stack.func_77978_p().func_74763_f("Energy"), InfinityTier.ARTIFACT.getPowerNeeded());
                }
                return 0L;
            }

            @Override
            public void setEnergyStored(long energy) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74772_a("Energy", Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        ItemInfinityBackpack.findFirstBackpack(playerEntity).ifPresent(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.func_190926_b()) {
                if (id == 4 && playerEntity instanceof ServerPlayerEntity) {
                    String backpackId = compound.func_74779_i("Id");
                    ItemStack cursor = playerEntity.field_71071_by.func_70445_o();
                    boolean shift = compound.func_74767_n("Shift");
                    boolean ctrl = compound.func_74767_n("Ctrl");
                    int button = compound.func_74762_e("Button");
                    int slot = compound.func_74762_e("Slot");
                    BackpackDataManager dataManager = BackpackDataManager.getData((IWorld)playerEntity.field_70170_p);
                    BackpackDataManager.BackpackItemHandler handler = dataManager.getBackpack(backpackId);
                    ItemStack result = ItemStack.field_190927_a;
                    boolean hasCursorChanged = false;
                    if (button == 2) {
                        ItemStack simulated = handler.extractItem(slot, 1, true);
                        if (!simulated.func_190926_b() && (cursor.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)simulated, (ItemStack)cursor))) {
                            result = handler.extractItem(slot, 1, false);
                            result.func_190920_e(cursor.func_190916_E() + 1);
                            hasCursorChanged = true;
                        }
                    } else if (cursor.func_190926_b()) {
                        int maxStack = handler.getStackInSlot(slot).func_77976_d();
                        if (button == 0) {
                            if (ctrl) {
                                BackpackDataManager.SlotDefinition definition;
                                definition.setVoidItems(!(definition = handler.getSlotDefinition(slot)).isVoidItems());
                            } else if (shift) {
                                if (handler.getSlotDefinition(slot).getAmount() == 0) {
                                    handler.getSlotDefinition(slot).setStack(ItemStack.field_190927_a);
                                    handler.getSlotDefinition(slot).setAmount(0);
                                } else {
                                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)handler.extractItem(slot, maxStack, false));
                                }
                            } else {
                                result = handler.extractItem(slot, maxStack, false);
                                hasCursorChanged = true;
                            }
                        } else if (button == 1) {
                            if (ctrl) {
                                BackpackDataManager.SlotDefinition definition;
                                definition.setRefillItems(!(definition = handler.getSlotDefinition(slot)).isRefillItems());
                            } else {
                                result = handler.extractItem(slot, maxStack / 2, false);
                                hasCursorChanged = true;
                            }
                        }
                    } else if (button == 0) {
                        result = handler.insertItem(slot, cursor, false);
                        hasCursorChanged = true;
                    } else if (button == 1 && handler.insertItem(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)cursor, (int)1), false).func_190926_b()) {
                        cursor.func_190918_g(1);
                        result = cursor;
                        hasCursorChanged = true;
                    }
                    if (hasCursorChanged) {
                        playerEntity.field_71071_by.func_70437_b(result);
                        ((ServerPlayerEntity)playerEntity).func_71113_k();
                    }
                    ItemInfinityBackpack.sync(playerEntity.field_70170_p, backpackId, (ServerPlayerEntity)playerEntity);
                }
                if (id == 10) {
                    ItemInfinityBackpack.setMagnet(stack, !ItemInfinityBackpack.isMagnetEnabled(stack));
                }
                if (id == 11) {
                    ItemInfinityBackpack.setPickUpMode(stack, (ItemInfinityBackpack.getPickUpMode(stack) + 1) % 4);
                }
                if (id == 3) {
                    this.setCanCharge(stack, !ItemInfinityBackpack.canCharge(stack));
                }
                if (id == -10) {
                    this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
                }
            }
        });
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74772_a("Energy", power);
        tagCompound.func_74757_a("Special", special);
        tagCompound.func_74778_a("Selected", ((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())).name());
        tagCompound.func_74757_a("CanCharge", true);
        stack.func_77982_d(tagCompound);
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new TranslationTextComponent("text.industrialforegoing.tooltip.can_hold").getString() + ": " + TextFormatting.DARK_AQUA + NumberFormat.getInstance(Locale.ROOT).format(ItemInfinityBackpack.getSlotSize(stack)) + TextFormatting.GRAY + " " + new TranslationTextComponent("text.industrialforegoing.tooltip.items").getString()));
        super.addTooltipDetails(key, stack, tooltip, advanced);
    }

    @Override
    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Tanks") && stack.func_77978_p().func_74775_l("Tanks").func_74764_b("biofuel")) {
            fuelAmount = stack.func_77978_p().func_74775_l("Tanks").func_74775_l("biofuel").func_74762_e("Amount");
        }
        return fuelAmount;
    }

    @Override
    public boolean enoughFuel(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        return this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (i + 1));
    }

    @Override
    public void consumeFuel(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        if (this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (i + 1))) {
            stack.func_77978_p().func_74775_l("Tanks").func_74775_l("biofuel").func_74768_a("Amount", Math.max(0, this.getFuelFromStack(stack) - FUEL_CONSUMPTION * (1 / (i + 1))));
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        return multimap;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Enchantments.field_185307_s == enchantment;
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    @Override
    @Nullable
    public Container createMenu(int menu, PlayerInventory p_createMenu_2_, PlayerEntity playerEntity) {
        return ItemInfinityBackpack.findFirstBackpack(playerEntity).map(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.func_190926_b()) {
                Object id;
                if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Id")) {
                    id = UUID.randomUUID();
                    CompoundNBT nbt = stack.func_196082_o();
                    nbt.func_74778_a("Id", ((UUID)id).toString());
                    BackpackDataManager.getData((IWorld)playerEntity.field_70170_p).createBackPack((UUID)id);
                    stack.func_77982_d(nbt);
                }
                id = stack.func_77978_p().func_74779_i("Id");
                return new BackpackContainer(((Function)ItemStackHarnessRegistry.getHarnessCreators().get(this)).apply(stack), (LocatorInstance)new InventoryStackLocatorInstance(target.getName(), target.getSlot()), new IWorldPosCallable(){

                    public <T> Optional<T> func_221484_a(BiFunction<World, BlockPos, T> p_221484_1_) {
                        return Optional.empty();
                    }
                }, playerEntity.field_71071_by, menu, (String)id);
            }
            return null;
        }).orElse(null);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        int i = 0;
        while (i < 32) {
            int x = i % 8;
            int y = i / 8;
            int finalI = i++;
            factory.add(() -> new SlotDefinitionGuiAddon(new ButtonComponent(16 + 18 * x, 21 + 18 * y, 18, 18).setId(4), finalI){

                @Override
                public ItemStack getItemStack() {
                    return (ItemStack)stack.get();
                }
            });
        }
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND_LEFT_TALL, -27, 10, true));
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 10, true));
        int x = 181;
        int y = 19;
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 0, 14, 14).setId(10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GREEN + new TranslationTextComponent("tooltip.industrialforegoing.backpack.magnet_enabled").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.RED + new TranslationTextComponent("tooltip.industrialforegoing.backpack.magnet_disabled").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.isMagnetEnabled((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 1, 14, 14).setId(11), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GREEN + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_all").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_PULL, new String[]{TextFormatting.GREEN + new TranslationTextComponent("tooltip.industrialforegoing.backpack.item_pickup_enabled").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(2, AssetTypes.BUTTON_SIDENESS_PUSH, new String[]{TextFormatting.GREEN + new TranslationTextComponent("tooltip.industrialforegoing.backpack.xp_pickup_enabled").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(3, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.RED + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_disabled").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra").getString(), TextFormatting.GRAY + new TranslationTextComponent("tooltip.industrialforegoing.backpack.pickup_extra_1").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.getPickUpMode((ItemStack)stack.get());
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 2, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GREEN + new TranslationTextComponent("text.industrialforegoing.display.charging").getString() + new TranslationTextComponent("text.industrialforegoing.display.enabled").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.RED + new TranslationTextComponent("text.industrialforegoing.display.charging").getString() + new TranslationTextComponent("text.industrialforegoing.display.disabled").getString()})}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 3, 14, 14).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{TextFormatting.GOLD + new TranslationTextComponent("text.industrialforegoing.display.special").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{TextFormatting.GOLD + new TranslationTextComponent("text.industrialforegoing.display.special").getString()})}){

                public int getState() {
                    return ModuleTool.INFINITY_BACKPACK.isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
        }
        return factory;
    }

    @Override
    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.IItemList[]{new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleTransportStorage.BLACK_HOLE_UNIT_COMMON)), new Ingredient.TagList(IndustrialTags.Items.GEAR_DIAMOND), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleTransportStorage.BLACK_HOLE_UNIT_COMMON)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleTransportStorage.BLACK_HOLE_TANK_COMMON)), new Ingredient.SingleItemList(new ItemStack((IItemProvider)ModuleTransportStorage.BLACK_HOLE_TANK_COMMON)), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagList(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), 2000), 400, new ItemStack((IItemProvider)this), FluidStack.EMPTY);
    }
}

