/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OreBucketItem
extends BucketItem {
    private static final String NBT_TAG = "Tag";

    public OreBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TAG)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidBucketWrapper(stack){

            @Nonnull
            public FluidStack getFluid() {
                FluidStack stack = new FluidStack(OreBucketItem.this.getFluid(), 1000);
                if (this.container.func_196082_o().func_74764_b(OreBucketItem.NBT_TAG)) {
                    String tag = this.container.func_196082_o().func_74779_i(OreBucketItem.NBT_TAG);
                    stack.getOrCreateTag().func_74778_a(OreBucketItem.NBT_TAG, tag);
                }
                return stack;
            }
        };
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TranslationTextComponent displayName = new TranslationTextComponent(this.func_77667_c(stack));
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TAG)) {
            String tag = stack.func_77978_p().func_74779_i(NBT_TAG);
            List items = TagCollectionManager.func_242178_a().func_241836_b().func_241834_b(new ResourceLocation(tag)).func_230236_b_();
            if (items.size() > 0) {
                TranslationTextComponent oreDisplayName = new TranslationTextComponent(((Item)items.get(0)).func_77658_a());
                return displayName.func_240702_b_(" (").func_230529_a_((ITextComponent)oreDisplayName).func_240702_b_(")");
            }
        }
        return displayName;
    }
}

