/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.combatslot;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import java.util.Optional;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

public enum CombatSlotType implements CombatSlotProvider
{
    PRIMARY(true),
    SECONDARY(true),
    MELEE(false),
    GRENADE(false){

        @Override
        protected int getAvailableSlot(PlayerInventory playerInventory, boolean ignoreEmpty) {
            int index = super.getAvailableSlot(playerInventory, false);
            return index == -1 ? 3 : index;
        }
    }
    ,
    EXTRA(false);

    private final boolean dropExistingItems;

    private CombatSlotType(boolean dropExistingItems) {
        this.dropExistingItems = dropExistingItems;
    }

    @Override
    public CombatSlotType getSlotType() {
        return this;
    }

    protected int getAvailableSlot(PlayerInventory playerInventory, boolean ignoreEmpty) {
        for (int i = 0; i < 6; ++i) {
            if (!ignoreEmpty && !playerInventory.func_70301_a(i).func_190926_b() || CombatSlotType.getSlotType(i) != this) continue;
            return i;
        }
        return -1;
    }

    public boolean addToInventory(ItemStack itemStack, PlayerInventory playerInventory, boolean ignoreEmpty) {
        int index = this.getAvailableSlot(playerInventory, ignoreEmpty);
        if (index == -1) {
            return false;
        }
        if (this.dropExistingItems && !playerInventory.func_70301_a(index).func_190926_b()) {
            ItemStack oldStack = playerInventory.func_70304_b(index);
            playerInventory.field_70458_d.func_146097_a(oldStack, true, true);
        }
        playerInventory.func_70299_a(index, itemStack);
        return true;
    }

    public static Optional<CombatSlotType> getSlotType(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.COMBAT_SLOT_PROVIDER).map(CombatSlotProvider::getSlotType);
    }

    public boolean isItemValid(ItemStack itemStack) {
        return itemStack.func_190926_b() || CombatSlotType.getSlotType(itemStack).map(this::equals).orElse(false) != false;
    }

    public static boolean isInventoryValid(PlayerInventory inventory) {
        for (int i = 0; i < 7; ++i) {
            if (CombatSlotType.isItemValidForSlot(inventory.func_70301_a(i), i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemValidForSlot(ItemStack itemStack, int slot) {
        return CombatSlotType.getSlotType(slot).isItemValid(itemStack);
    }

    public static CombatSlotType getSlotType(int slot) {
        switch (slot) {
            case 0: {
                return PRIMARY;
            }
            case 1: {
                return SECONDARY;
            }
            case 2: {
                return MELEE;
            }
            case 3: 
            case 4: 
            case 5: {
                return GRENADE;
            }
            case 6: {
                return EXTRA;
            }
        }
        throw new IllegalArgumentException("Invalid slot");
    }
}

