/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class ItemUtils {
    public static void saveInventory(CompoundNBT compound, String name, IInventory inventory) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74768_a("slot", i);
            inventory.func_70301_a(i).func_77955_b(slot);
            tagList.add((Object)slot);
        }
        compound.func_218657_a(name, (INBT)tagList);
    }

    public static void saveInventory(CompoundNBT compound, String name, NonNullList<ItemStack> inventory) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inventory.size(); ++i) {
            if (((ItemStack)inventory.get(i)).func_190926_b()) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74768_a("slot", i);
            ((ItemStack)inventory.get(i)).func_77955_b(slot);
            tagList.add((Object)slot);
        }
        compound.func_218657_a(name, (INBT)tagList);
    }

    public static void saveItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list) {
        ItemUtils.saveItemList(compound, name, list, true);
    }

    public static void saveItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list, boolean includeEmpty) {
        ListNBT itemList = new ListNBT();
        for (ItemStack stack : list) {
            if (!includeEmpty && stack.func_190926_b()) continue;
            itemList.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a(name, (INBT)itemList);
    }

    public static void readInventory(CompoundNBT compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT tagList = compound.func_150295_c(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT slot = tagList.func_150305_b(i);
            int j = slot.func_74762_e("slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)slot));
        }
    }

    public static void readInventory(CompoundNBT compound, String name, NonNullList<ItemStack> inventory) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT tagList = compound.func_150295_c(name, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT slot = tagList.func_150305_b(i);
            int j = slot.func_74762_e("slot");
            if (j < 0 || j >= inventory.size()) continue;
            inventory.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)slot));
        }
    }

    public static NonNullList<ItemStack> readItemList(CompoundNBT compound, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.func_191196_a();
        if (!compound.func_74764_b(name)) {
            return items;
        }
        ListNBT itemList = compound.func_150295_c(name, 10);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i));
            if (!includeEmpty) {
                if (item.func_190926_b()) continue;
                items.add((Object)item);
                continue;
            }
            items.add((Object)item);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(CompoundNBT compound, String name) {
        return ItemUtils.readItemList(compound, name, true);
    }

    public static void readItemList(CompoundNBT compound, String name, NonNullList<ItemStack> list) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT itemList = compound.func_150295_c(name, 10);
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)itemList.func_150305_b(i)));
        }
    }
}

