/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.craftingdead.core.world.clothing.DefaultClothing;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ClothingItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final boolean fireImmunity;

    public ClothingItem(Properties properties) {
        super((Item.Properties)properties);
        this.attributeModifiers = properties.attributeModifiers.build();
        this.fireImmunity = properties.fireImmunity;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundNBT nbt) {
        return new SimpleCapabilityProvider(LazyOptional.of(() -> new DefaultClothing(this.attributeModifiers, this.fireImmunity, new ResourceLocation(this.getRegistryName().func_110624_b(), "textures/clothing/" + this.getRegistryName().func_110623_a() + "_default.png"))), () -> Capabilities.CLOTHING);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, lines, tooltipFlag);
        if (this.fireImmunity) {
            lines.add((ITextComponent)new TranslationTextComponent("item_lore.clothing.immune_to_fire").func_240699_a_(TextFormatting.GRAY));
        }
        if (!this.attributeModifiers.isEmpty()) {
            lines.add(StringTextComponent.field_240750_d_);
            lines.add((ITextComponent)new TranslationTextComponent("item.modifiers.clothing").func_240699_a_(TextFormatting.GRAY));
            for (Map.Entry entry : this.attributeModifiers.entries()) {
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double amount = modifier.func_111164_d();
                double multipliedAmount = modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.field_233820_c_) ? amount * 10.0 : amount) : amount * 100.0;
                if (modifier.func_111167_a() == Item.field_111210_e || modifier.func_111167_a() == Item.field_185050_h) {
                    lines.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.modifier.equals." + modifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(multipliedAmount), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())})).func_240699_a_(TextFormatting.DARK_GREEN));
                    continue;
                }
                if (amount > 0.0) {
                    lines.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + modifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(multipliedAmount), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                lines.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + modifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(multipliedAmount *= -1.0), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
        }
    }

    public static class Properties
    extends Item.Properties {
        private ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeModifiers = ImmutableMultimap.builder();
        private boolean fireImmunity;

        public Properties addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.attributeModifiers.put((Object)attribute, (Object)modifier);
            return this;
        }

        public Properties setFireImmunity(boolean fireImmunity) {
            this.fireImmunity = fireImmunity;
            return this;
        }
    }
}

