/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.AttachmentLike;
import com.craftingdead.core.world.gun.skin.Paint;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class GunCraftSlot
extends Slot {
    private final Inventory craftingInventory;

    public GunCraftSlot(CraftResultInventory inventory, int slotIndex, int x, int y, Inventory craftingInventory) {
        super((IInventory)inventory, slotIndex, x, y);
        this.craftingInventory = craftingInventory;
    }

    public boolean func_75214_a(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof GunItem;
    }

    public void func_75215_d(ItemStack itemStack) {
        itemStack.getCapability(Capabilities.GUN).ifPresent(gun -> {
            gun.getAttachments().forEach(attachment -> this.craftingInventory.func_70299_a(attachment.getInventorySlot().getIndex(), new ItemStack((IItemProvider)attachment)));
            gun.setAttachments(Collections.emptySet());
            this.craftingInventory.func_70299_a(GunCraftSlotType.PAINT.getIndex(), gun.getPaintStack());
            gun.setPaintStack(ItemStack.field_190927_a);
        });
        super.func_75215_d(itemStack);
    }

    public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack gunStack) {
        gunStack.getCapability(Capabilities.GUN).ifPresent(gun -> {
            gun.setPaintStack(ItemStack.field_190927_a);
            HashSet<Attachment> attachments = new HashSet<Attachment>();
            for (int i = 0; i < this.craftingInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.craftingInventory.func_70301_a(i);
                if (gun.isAcceptedAttachment(itemStack) && itemStack.func_77973_b() instanceof AttachmentLike) {
                    attachments.add(((AttachmentLike)itemStack.func_77973_b()).asAttachment());
                    this.craftingInventory.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                if (!Paint.isValid(gunStack, itemStack)) continue;
                gun.setPaintStack(itemStack);
                this.craftingInventory.func_70299_a(i, ItemStack.field_190927_a);
            }
            gun.setAttachments(attachments);
        });
        return super.func_190901_a(playerEntity, gunStack);
    }
}

