/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.inventory.AbstractMenu;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.inventory.PredicateItemHandlerSlot;
import com.craftingdead.core.world.item.GunItem;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GenericMenu
extends AbstractMenu {
    private final int rows;

    public GenericMenu(ContainerType<?> menuType, int windowId, PlayerInventory playerInventory, int rows, BiPredicate<PredicateItemHandlerSlot, ItemStack> predicate) {
        this(menuType, windowId, playerInventory, (IItemHandler)new ItemStackHandler(9 * rows), rows, predicate);
    }

    public GenericMenu(ContainerType<?> type, int id, PlayerInventory playerInventory, IItemHandler itemHandler, int rows, BiPredicate<PredicateItemHandlerSlot, ItemStack> predicate) {
        super(type, id, (IInventory)playerInventory, itemHandler);
        assert (itemHandler.getSlots() >= rows * 9);
        this.rows = rows;
        this.addPlayerInventorySlots();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new PredicateItemHandlerSlot(itemHandler, j + i * 9, 8 + j * 18, 18 + i * 18, predicate));
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public int getInventoryOffset() {
        return 19 + (this.rows - 4) * 18;
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return true;
    }

    public static GenericMenu createVest(int windowId, PlayerInventory playerInventory, IItemHandler itemHandler) {
        return new GenericMenu((ContainerType)ModMenuTypes.VEST.get(), windowId, playerInventory, itemHandler, 2, (slot, itemStack) -> !itemStack.getCapability(Capabilities.STORAGE).isPresent() && !(itemStack.func_77973_b() instanceof GunItem));
    }

    public static GenericMenu createVest(int windowId, PlayerInventory playerInventory) {
        return new GenericMenu((ContainerType)ModMenuTypes.VEST.get(), windowId, playerInventory, 2, (slot, itemStack) -> !itemStack.getCapability(Capabilities.STORAGE).isPresent() && !(itemStack.func_77973_b() instanceof GunItem));
    }
}

