/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.type.aimable;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.capability.SerializableCapabilityProvider;
import com.craftingdead.core.world.gun.type.AbstractGunType;
import com.craftingdead.core.world.gun.type.aimable.AimableGun;
import com.craftingdead.core.world.gun.type.aimable.AimableGunClient;
import com.google.common.collect.ImmutableSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AimableGunType
extends AbstractGunType {
    private final boolean boltAction;

    protected AimableGunType(Builder builder) {
        super(builder);
        this.boltAction = builder.boltAction;
    }

    @Override
    public ICapabilityProvider createCapabilityProvider(ItemStack itemStack) {
        return new SerializableCapabilityProvider(LazyOptional.of(() -> AimableGun.create(AimableGunClient::new, itemStack, this)), ImmutableSet.of(() -> Capabilities.GUN, () -> Capabilities.COMBAT_SLOT_PROVIDER, () -> Capabilities.SCOPE), CompoundNBT::new);
    }

    public boolean hasBoltAction() {
        return this.boltAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractGunType.Builder<Builder> {
        private boolean boltAction = false;

        private Builder() {
            super(AimableGunType::new);
        }

        public Builder setBoltAction(boolean boltAction) {
            this.boltAction = boltAction;
            return this;
        }
    }
}

