/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.type.aimable;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.type.TypedGun;
import com.craftingdead.core.world.gun.type.aimable.AimableGunClient;
import com.craftingdead.core.world.gun.type.aimable.AimableGunType;
import com.craftingdead.core.world.item.scope.Scope;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class AimableGun
extends TypedGun<AimableGunType>
implements Scope {
    private boolean waitingForBoltAction;

    public static AimableGun create(Function<AimableGun, AimableGunClient> clientFactory, ItemStack itemStack, AimableGunType type) {
        AimableGun gun = new AimableGun(clientFactory, itemStack, type);
        gun.initialize();
        return gun;
    }

    private AimableGun(Function<AimableGun, AimableGunClient> clientFactory, ItemStack itemStack, AimableGunType type) {
        super(clientFactory, itemStack, type);
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        super.reset(living);
        this.waitingForBoltAction = false;
    }

    @Override
    public void tick(LivingExtension<?, ?> living) {
        long timeDelta = Util.func_211177_b() - this.lastShotMs;
        if (timeDelta >= (long)((AimableGunType)this.getType()).getFireDelayMs() && this.waitingForBoltAction) {
            this.waitingForBoltAction = false;
            if (!this.isPerformingSecondaryAction()) {
                this.setPerformingSecondaryAction(living, true, false);
            }
        }
        super.tick(living);
    }

    @Override
    protected void processShot(LivingExtension<?, ?> living, Random random) {
        super.processShot(living, random);
        if (this.isPerformingSecondaryAction() && ((AimableGunType)this.getType()).hasBoltAction()) {
            this.setPerformingSecondaryAction(living, false, false);
            this.waitingForBoltAction = true;
        }
    }

    @Override
    public boolean isAiming(Entity entity) {
        return this.isPerformingSecondaryAction();
    }

    @Override
    public float getZoomMultiplier(Entity entity) {
        return this.hasIronSight() ? 2.0f : this.getAttachmentMultiplier(Attachment.MultiplierType.ZOOM);
    }

    @Override
    public Optional<ResourceLocation> getOverlayTexture(Entity entity) {
        for (Attachment attachment : this.getAttachments()) {
            if (!attachment.isScope()) continue;
            return Optional.of(new ResourceLocation(attachment.getRegistryName().func_110624_b(), "textures/scope/" + attachment.getRegistryName().func_110623_a() + ".png"));
        }
        return Optional.empty();
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingRightMouseAction, boolean sendUpdate) {
        if (!this.waitingForBoltAction) {
            super.setPerformingSecondaryAction(living, performingRightMouseAction, sendUpdate);
        }
    }

    @Override
    public int getOverlayTextureWidth() {
        return 2048;
    }

    @Override
    public int getOverlayTextureHeight() {
        return 512;
    }
}

