/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.type;

import com.craftingdead.core.client.animation.AnimationType;
import com.craftingdead.core.client.animation.GunAnimation;
import com.craftingdead.core.world.gun.FireMode;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.item.combatslot.CombatSlotType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class AbstractGunType {
    private final int fireDelayMs;
    private final int damage;
    private final int reloadDurationTicks;
    private final float accuracyPct;
    private final float recoil;
    private final int roundsPerShot;
    private final boolean crosshair;
    private final Set<FireMode> fireModes;
    private final Supplier<SoundEvent> shootSound;
    private final Supplier<SoundEvent> distantShootSound;
    private final Supplier<SoundEvent> silencedShootSound;
    private final Supplier<SoundEvent> reloadSound;
    private final Map<AnimationType, Supplier<GunAnimation>> animations;
    private final Set<Supplier<? extends Item>> acceptedMagazines;
    private final Supplier<? extends Item> defaultMagazine;
    private final Set<Supplier<? extends Attachment>> acceptedAttachments;
    private final Gun.SecondaryActionTrigger secondaryActionTrigger;
    private final Predicate<Gun> triggerPredicate;
    private final Supplier<SoundEvent> secondaryActionSound;
    private final long secondaryActionSoundRepeatDelayMs;
    private final double range;
    private final CombatSlotType combatSlotType;

    protected AbstractGunType(Builder<?> builder) {
        this.fireDelayMs = ((Builder)builder).fireDelayMs;
        this.damage = ((Builder)builder).damage;
        this.reloadDurationTicks = ((Builder)builder).reloadDurationTicks;
        this.accuracyPct = ((Builder)builder).accuracy;
        this.recoil = ((Builder)builder).recoil;
        this.roundsPerShot = ((Builder)builder).roundsPerShot;
        this.crosshair = ((Builder)builder).crosshair;
        this.fireModes = ((Builder)builder).fireModes;
        this.shootSound = ((Builder)builder).shootSound;
        this.distantShootSound = ((Builder)builder).distantShootSound;
        this.silencedShootSound = ((Builder)builder).silencedShootSound;
        this.reloadSound = ((Builder)builder).reloadSound;
        this.animations = ((Builder)builder).animations;
        this.acceptedMagazines = ((Builder)builder).acceptedMagazines;
        this.defaultMagazine = ((Builder)builder).defaultMagazine;
        this.acceptedAttachments = ((Builder)builder).acceptedAttachments;
        this.secondaryActionTrigger = ((Builder)builder).rightMouseActionTriggerType;
        this.triggerPredicate = ((Builder)builder).triggerPredicate;
        this.secondaryActionSound = ((Builder)builder).secondaryActionSound;
        this.secondaryActionSoundRepeatDelayMs = ((Builder)builder).secondaryActionSoundRepeatDelayMs;
        this.range = ((Builder)builder).range;
        this.combatSlotType = ((Builder)builder).combatSlotType;
    }

    public abstract ICapabilityProvider createCapabilityProvider(ItemStack var1);

    public int getFireDelayMs() {
        return this.fireDelayMs;
    }

    public int getFireRateRPM() {
        return 60000 / this.getFireDelayMs();
    }

    public float getDamage() {
        return this.damage;
    }

    public int getReloadDurationTicks() {
        return this.reloadDurationTicks;
    }

    public float getAccuracyPct() {
        return this.accuracyPct;
    }

    public float getRecoil() {
        return this.recoil;
    }

    public double getRange() {
        return this.range;
    }

    public int getRoundsPerShot() {
        return this.roundsPerShot;
    }

    public boolean hasCrosshair() {
        return this.crosshair;
    }

    public Set<FireMode> getFireModes() {
        return this.fireModes;
    }

    public SoundEvent getShootSound() {
        return this.shootSound.get();
    }

    public Optional<SoundEvent> getDistantShootSound() {
        return Optional.ofNullable(this.distantShootSound).map(Supplier::get);
    }

    public Optional<SoundEvent> getSilencedShootSound() {
        return Optional.ofNullable(this.silencedShootSound).map(Supplier::get);
    }

    public Optional<SoundEvent> getReloadSound() {
        return Optional.ofNullable(this.reloadSound).map(Supplier::get);
    }

    public Map<AnimationType, Supplier<GunAnimation>> getAnimations() {
        return this.animations;
    }

    public AmmoProvider createAmmoProvider() {
        MagazineAmmoProvider ammoProvider = new MagazineAmmoProvider(this.getDefaultMagazine().func_190903_i());
        ammoProvider.getExpectedMagazine().setSize(0);
        return ammoProvider;
    }

    public Set<Item> getAcceptedMagazines() {
        return this.acceptedMagazines.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Item getDefaultMagazine() {
        return this.defaultMagazine.get();
    }

    public Set<Attachment> getAcceptedAttachments() {
        return this.acceptedAttachments.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Gun.SecondaryActionTrigger getSecondaryActionTrigger() {
        return this.secondaryActionTrigger;
    }

    public Predicate<Gun> getTriggerPredicate() {
        return this.triggerPredicate;
    }

    public Optional<SoundEvent> getSecondaryActionSound() {
        return Optional.ofNullable(this.secondaryActionSound).map(Supplier::get);
    }

    public long getSecondaryActionSoundRepeatDelayMs() {
        return this.secondaryActionSoundRepeatDelayMs;
    }

    public CombatSlotType getCombatSlotType() {
        return this.combatSlotType;
    }

    public static class Builder<SELF extends Builder<SELF>> {
        private final Function<SELF, AbstractGunType> factory;
        private int fireDelayMs;
        private int damage;
        private int reloadDurationTicks;
        private int roundsPerShot = 1;
        private float accuracy;
        private float recoil;
        private double range;
        private boolean crosshair = true;
        private final Set<FireMode> fireModes = EnumSet.noneOf(FireMode.class);
        private Supplier<SoundEvent> shootSound;
        private Supplier<SoundEvent> distantShootSound = () -> null;
        private Supplier<SoundEvent> silencedShootSound = () -> null;
        private Supplier<SoundEvent> reloadSound = () -> null;
        private final Map<AnimationType, Supplier<GunAnimation>> animations = new EnumMap<AnimationType, Supplier<GunAnimation>>(AnimationType.class);
        private final Set<Supplier<? extends Item>> acceptedMagazines = new HashSet<Supplier<? extends Item>>();
        private Supplier<? extends Item> defaultMagazine;
        private final Set<Supplier<? extends Attachment>> acceptedAttachments = new HashSet<Supplier<? extends Attachment>>();
        private final Set<Supplier<? extends Item>> acceptedPaints = new HashSet<Supplier<? extends Item>>();
        private Gun.SecondaryActionTrigger rightMouseActionTriggerType = Gun.SecondaryActionTrigger.TOGGLE;
        private Predicate<Gun> triggerPredicate = gun -> true;
        private Supplier<SoundEvent> secondaryActionSound = () -> null;
        private long secondaryActionSoundRepeatDelayMs = -1L;
        private CombatSlotType combatSlotType = CombatSlotType.PRIMARY;

        public Builder(Function<SELF, AbstractGunType> factory) {
            this.factory = factory;
        }

        public SELF setFireDelayMs(int fireDelayMs) {
            this.fireDelayMs = fireDelayMs;
            return this.self();
        }

        public SELF setDamage(int damage) {
            this.damage = damage;
            return this.self();
        }

        public SELF setReloadDurationTicks(int reloadDurationTicks) {
            this.reloadDurationTicks = reloadDurationTicks;
            return this.self();
        }

        public SELF setRoundsPerShot(int roundsPerShot) {
            this.roundsPerShot = roundsPerShot;
            return this.self();
        }

        public SELF setCrosshair(boolean crosshair) {
            this.crosshair = crosshair;
            return this.self();
        }

        public SELF setAccuracy(float accuracy) {
            this.accuracy = accuracy;
            return this.self();
        }

        public SELF setRecoil(float recoil) {
            this.recoil = recoil;
            return this.self();
        }

        public SELF setRange(double range) {
            this.range = range;
            return this.self();
        }

        public SELF addFireMode(FireMode fireMode) {
            this.fireModes.add(fireMode);
            return this.self();
        }

        public SELF setShootSound(Supplier<SoundEvent> shootSound) {
            this.shootSound = shootSound;
            return this.self();
        }

        public SELF setDistantShootSound(Supplier<SoundEvent> distantShootSound) {
            this.distantShootSound = distantShootSound;
            return this.self();
        }

        public SELF setSilencedShootSound(Supplier<SoundEvent> silencedShootSound) {
            this.silencedShootSound = silencedShootSound;
            return this.self();
        }

        public SELF setReloadSound(Supplier<SoundEvent> reloadSound) {
            this.reloadSound = reloadSound;
            return this.self();
        }

        public SELF addAnimation(AnimationType type, Supplier<GunAnimation> animation) {
            this.animations.put(type, animation);
            return this.self();
        }

        public SELF addAcceptedMagazine(Supplier<? extends Item> acceptedMagazine) {
            this.acceptedMagazines.add(acceptedMagazine);
            return this.self();
        }

        public SELF setDefaultMagazine(Supplier<? extends Item> defaultMagazine) {
            if (this.defaultMagazine != null) {
                throw new IllegalArgumentException("Default magazine already set");
            }
            this.defaultMagazine = defaultMagazine;
            return this.addAcceptedMagazine(defaultMagazine);
        }

        public SELF addAcceptedAttachment(Supplier<? extends Attachment> acceptedAttachment) {
            this.acceptedAttachments.add(acceptedAttachment);
            return this.self();
        }

        public SELF addAcceptedPaint(Supplier<? extends Item> acceptedPaint) {
            this.acceptedPaints.add(acceptedPaint);
            return this.self();
        }

        public SELF setRightMouseActionTriggerType(Gun.SecondaryActionTrigger rightMouseActionTriggerType) {
            this.rightMouseActionTriggerType = rightMouseActionTriggerType;
            return this.self();
        }

        public SELF setTriggerPredicate(Predicate<Gun> triggerPredicate) {
            this.triggerPredicate = triggerPredicate;
            return this.self();
        }

        public SELF setSecondaryActionSound(Supplier<SoundEvent> secondaryActionSound) {
            this.secondaryActionSound = secondaryActionSound;
            return this.self();
        }

        public SELF setSecondaryActionSoundRepeatDelayMs(long secondaryActionSoundRepeatDelayMs) {
            this.secondaryActionSoundRepeatDelayMs = secondaryActionSoundRepeatDelayMs;
            return this.self();
        }

        public SELF setCombatSlotType(CombatSlotType combatSlotType) {
            this.combatSlotType = combatSlotType;
            return this.self();
        }

        public AbstractGunType build() {
            return this.factory.apply(this.self());
        }

        protected final SELF self() {
            return (SELF)this;
        }
    }
}

