/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.skin;

import com.craftingdead.core.world.gun.skin.Skins;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryKeyCodec;

public class Skin {
    public static final Codec<Skin> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("name").forGetter(Skin::getName), (App)ResourceLocation.field_240908_a_.listOf().fieldOf("acceptedGuns").forGetter(Skin::getAcceptedGuns)).apply((Applicative)instance, Skin::new));
    public static final Codec<Supplier<Skin>> CODEC = RegistryKeyCodec.func_241794_a_(Skins.SKINS, DIRECT_CODEC);
    private final ResourceLocation name;
    private final List<ResourceLocation> acceptedGuns;

    public Skin(ResourceLocation name, List<ResourceLocation> acceptedGuns) {
        this.name = name;
        this.acceptedGuns = acceptedGuns;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public List<ResourceLocation> getAcceptedGuns() {
        return Collections.unmodifiableList(this.acceptedGuns);
    }

    public ResourceLocation getTextureLocation(ResourceLocation gunName) {
        return new ResourceLocation(this.getName().func_110624_b(), "gun/" + gunName.func_110623_a() + "_" + this.getName().func_110623_a());
    }
}

