/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.magazine;

import com.craftingdead.core.world.gun.magazine.Magazine;
import com.craftingdead.core.world.item.MagazineItem;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MagazineImpl
implements Magazine {
    private final MagazineItem magazineItem;
    private final AtomicInteger size;
    private boolean dirty;

    public MagazineImpl(MagazineItem magazineItem) {
        this.magazineItem = magazineItem;
        this.size = new AtomicInteger(magazineItem.getSize());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("size", this.size.get());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.size.set(nbt.func_74762_e("size"));
    }

    @Override
    public float getArmorPenetration() {
        return this.magazineItem.getArmorPenetration();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public void setSize(int size) {
        this.dirty = true;
        this.size.set(size);
    }

    @Override
    public void refill() {
        this.dirty = true;
        this.size.set(this.magazineItem.getSize());
    }

    @Override
    public int decrementSize() {
        this.dirty = true;
        return this.size.decrementAndGet();
    }

    @Override
    public boolean hasCustomTexture() {
        return this.magazineItem.hasCustomTexture();
    }

    @Override
    public int getMaxSize() {
        return this.magazineItem.getSize();
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        out.func_150787_b(this.size.get());
        this.dirty = false;
    }

    @Override
    public void decode(PacketBuffer in) {
        this.size.set(in.func_150792_a());
    }

    @Override
    public boolean requiresSync() {
        return this.dirty;
    }
}

